/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.pkiexpress.ChangesFileModel;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.PadesMeasurementUnits;
import com.lacunasoftware.pkiexpress.PadesPageOptimization;
import com.lacunasoftware.pkiexpress.PdfMark;
import com.lacunasoftware.pkiexpress.PdfMarkModel;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class PdfMarker
extends PkiExpressOperator {
    private PadesMeasurementUnits measurementUnits;
    private PadesPageOptimization pageOptimization;
    private List<PdfMark> marks = new ArrayList<PdfMark>();
    private Path filePath;
    private Path outputFilePath;
    private boolean overwriteOriginalFile = false;

    public PdfMarker(PkiExpressConfig config) {
        super(config);
        this.measurementUnits = PadesMeasurementUnits.Centimeters;
    }

    public PdfMarker() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setFile(InputStream stream) throws IOException {
        this.filePath = this.writeToTempFile(stream);
    }

    public void setFile(byte[] content) throws IOException {
        this.setFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.filePath = path;
    }

    public void setFile(String path) throws IOException {
        this.setFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setOutputFilePath(Path outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    public PadesMeasurementUnits getMeasurementUnits() {
        return this.measurementUnits;
    }

    public void setMeasurementUnits(PadesMeasurementUnits measurementUnits) {
        this.measurementUnits = measurementUnits;
    }

    public PadesPageOptimization getPageOptimization() {
        return this.pageOptimization;
    }

    public void setPageOptimization(PadesPageOptimization pageOptimization) {
        this.pageOptimization = pageOptimization;
    }

    public List<PdfMark> getMarks() {
        return this.marks;
    }

    public void setMarks(List<PdfMark> marks) {
        this.marks = marks;
    }

    public void addMark(PdfMark mark) {
        if (this.marks == null) {
            this.marks = new ArrayList<PdfMark>();
        }
        this.marks.add(mark);
    }

    public boolean getOverwriteOriginalFile() {
        return this.overwriteOriginalFile;
    }

    public void setOverwriteOriginalFile(boolean overwriteOriginalFile) {
        this.overwriteOriginalFile = overwriteOriginalFile;
    }

    public void apply() throws IOException {
        if (this.filePath == null) {
            throw new RuntimeException("The file to be marked was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.filePath.toString());
        Path changesFilePath = this.generateChangesFile(this.marks, this.measurementUnits, this.pageOptimization);
        args.add(changesFilePath.toString());
        if (this.overwriteOriginalFile) {
            args.add("--overwrite");
        } else {
            args.add(this.outputFilePath.toString());
        }
        this.versionManager.requireVersion(new Version("1.3"));
        this.invoke(CommandEnum.CommandEditPdf, args);
    }

    private Path generateChangesFile(List<PdfMark> marks, PadesMeasurementUnits measurementUnits, PadesPageOptimization pageOptimization) throws IOException {
        ChangesFileModel request = new ChangesFileModel();
        ArrayList<PdfMarkModel> marksModels = new ArrayList<PdfMarkModel>();
        for (PdfMark pm : marks) {
            marksModels.add(pm.toModel());
        }
        request.setMarks(marksModels);
        if (measurementUnits != null) {
            request.setMeasurementUnits(measurementUnits.toString());
        }
        if (pageOptimization != null) {
            request.setPageOptimization(pageOptimization.toModel());
        }
        Path tempFilePath = this.createTempFile();
        FileOutputStream outputStream = new FileOutputStream(tempFilePath.toFile());
        new ObjectMapper().writeValue((OutputStream)outputStream, (Object)request);
        ((OutputStream)outputStream).close();
        return tempFilePath;
    }
}

