/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.PadesHorizontalAlign;
import com.lacunasoftware.pkiexpress.PadesVisualRectangle;
import com.lacunasoftware.pkiexpress.PdfMarkElement;
import com.lacunasoftware.pkiexpress.PdfMarkElementModel;
import com.lacunasoftware.pkiexpress.PdfMarkElementType;
import com.lacunasoftware.pkiexpress.PdfTextSection;
import com.lacunasoftware.pkiexpress.PdfTextSectionModel;
import java.util.ArrayList;
import java.util.List;

public class PdfMarkTextElement
extends PdfMarkElement<PdfMarkTextElement> {
    private List<PdfTextSection> textSections;
    private PadesHorizontalAlign align = PadesHorizontalAlign.Left;

    public PdfMarkTextElement() {
        super(PdfMarkElementType.Text);
        this.textSections = new ArrayList<PdfTextSection>();
    }

    public PdfMarkTextElement(PadesVisualRectangle relativeContainer, List<PdfTextSection> sections) {
        super(PdfMarkElementType.Text, relativeContainer);
        this.textSections = sections;
    }

    @Override
    public PdfMarkElementModel toModel() {
        PdfMarkElementModel model = super.toModel();
        model.setAlign(PdfMarkElementModel.AlignEnum.valueOf(this.align.toString()));
        ArrayList<PdfTextSectionModel> textSectionsModels = new ArrayList<PdfTextSectionModel>();
        for (PdfTextSection section : this.textSections) {
            textSectionsModels.add(section.toModel());
        }
        model.setTextSections(textSectionsModels);
        return model;
    }

    public PdfMarkTextElement alignTextLeft() {
        this.align = PadesHorizontalAlign.Left;
        return this;
    }

    public PdfMarkTextElement alignTextRight() {
        this.align = PadesHorizontalAlign.Right;
        return this;
    }

    public PdfMarkTextElement alignTextCenter() {
        this.align = PadesHorizontalAlign.Center;
        return this;
    }

    public PdfMarkTextElement addSection(PdfTextSection section) {
        this.textSections.add(section);
        return this;
    }

    public PdfMarkTextElement addSection(String text) {
        this.textSections.add(new PdfTextSection(text));
        return this;
    }

    public List<PdfTextSection> getTextSections() {
        return this.textSections;
    }

    public void setTextSections(List<PdfTextSection> textSections) {
        this.textSections = textSections;
    }

    public PadesHorizontalAlign getAlign() {
        return this.align;
    }

    public void setAlign(PadesHorizontalAlign align) {
        this.align = align;
    }
}

