/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.PdfMarkImageModel;
import com.lacunasoftware.pkiexpress.ResourceContentOrReference;
import com.lacunasoftware.pkiexpress.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PdfMarkImage {
    private String url;
    private String content;
    private String mimeType;
    private int alpha = 100;

    public PdfMarkImage() {
    }

    public PdfMarkImage(byte[] imageContent, String mimeType) {
        this();
        this.content = Util.encodeBase64(imageContent);
        this.mimeType = mimeType;
    }

    public PdfMarkImage(String imageUrl, String mimeType) {
        this();
        this.url = imageUrl;
        this.mimeType = mimeType;
    }

    public void setContentFromFile(InputStream stream) throws IOException {
        this.content = Util.encodeBase64(Util.readStream(stream));
    }

    public void setContentFromFile(byte[] content) throws IOException {
        this.setContentFromFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setContentFromFile(Path path) throws IOException {
        this.content = Util.encodeBase64(Files.readAllBytes(path));
    }

    public void setContentFromFile(String filePath) throws IOException {
        this.setContentFromFile(Paths.get(filePath, new String[0]));
    }

    public PdfMarkImageModel toModel() {
        PdfMarkImageModel model = new PdfMarkImageModel();
        model.setOpacity((double)this.alpha / 1.0);
        if (this.content != null) {
            ResourceContentOrReference resource = new ResourceContentOrReference();
            resource.setContent(this.content);
            resource.setMimeType(this.mimeType);
            model.setResource(resource);
        } else if (this.url != null && this.url.length() > 0) {
            ResourceContentOrReference resource = new ResourceContentOrReference();
            resource.setUrl(this.url);
            resource.setMimeType(this.mimeType);
            model.setResource(resource);
        } else {
            throw new RuntimeException("The image content was not set, neither its URL");
        }
        return model;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

