/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.PadesVisualRectangle;
import com.lacunasoftware.pkiexpress.PdfMarkElementModel;
import com.lacunasoftware.pkiexpress.PdfMarkElementType;

public abstract class PdfMarkElement<T extends PdfMarkElement<T>> {
    protected PdfMarkElementType elementType;
    protected PadesVisualRectangle relativeContainer;
    protected int rotation = 0;
    protected double opacity = 100.0;

    public PdfMarkElement(PdfMarkElementType type) {
        this.elementType = type;
    }

    public PdfMarkElement(PdfMarkElementType type, PadesVisualRectangle relativeContainer) {
        this(type);
        this.relativeContainer = relativeContainer;
    }

    public PdfMarkElementModel toModel() {
        PdfMarkElementModel model = new PdfMarkElementModel();
        model.setElementType(PdfMarkElementModel.ElementTypeEnum.valueOf(this.elementType.toString()));
        if (this.relativeContainer != null) {
            model.setRelativeContainer(this.relativeContainer.toModel());
        }
        model.setRotation(this.rotation);
        model.setOpacity(this.opacity);
        return model;
    }

    public T onContainer(PadesVisualRectangle relativeContainer) {
        this.relativeContainer = relativeContainer;
        return (T)this;
    }

    public T withRotation(int rotation) {
        this.rotation = rotation;
        return (T)this;
    }

    public T rotate90Clockwise() {
        this.rotation = 270;
        return (T)this;
    }

    public T rotate90Counterclockwise() {
        this.rotation = 90;
        return (T)this;
    }

    public T rotate180() {
        this.rotation = 180;
        return (T)this;
    }

    public T withOpacity(double opacity) {
        this.opacity = opacity;
        return (T)this;
    }

    public PdfMarkElementType getElementType() {
        return this.elementType;
    }

    public void setElementType(PdfMarkElementType elementType) {
        this.elementType = elementType;
    }

    public PadesVisualRectangle getRelativeContainer() {
        return this.relativeContainer;
    }

    public void setRelativeContainer(PadesVisualRectangle relativeContainer) {
        this.relativeContainer = relativeContainer;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }
}

