/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.pkiexpress.PadesHorizontalAlign;
import com.lacunasoftware.pkiexpress.PadesVerticalAlign;
import com.lacunasoftware.pkiexpress.PadesVisualImageModel;
import com.lacunasoftware.pkiexpress.ResourceContentOrReference;
import com.lacunasoftware.pkiexpress.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PadesVisualImage {
    private String url;
    private byte[] content;
    private String mimeType;
    private int opacity = 100;
    private PadesHorizontalAlign horizontalAlign = PadesHorizontalAlign.Center;
    private PadesVerticalAlign verticalAlign = PadesVerticalAlign.Center;

    public PadesVisualImage() {
    }

    public PadesVisualImage(byte[] imageContent, String imageMimeType) {
        this();
        this.content = imageContent;
        this.mimeType = imageMimeType;
    }

    public PadesVisualImage(String imageUrl, String imageMimeType) {
        this();
        this.url = imageUrl;
        this.mimeType = imageMimeType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] imageContent) {
        this.content = imageContent;
    }

    public void setContent(InputStream imageStream) throws IOException {
        this.content = Util.readStream(imageStream);
    }

    public void setContent(String imagePath) throws IOException {
        this.content = Files.readAllBytes(Paths.get(imagePath, new String[0]));
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public PadesHorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(PadesHorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public PadesVerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(PadesVerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public PadesVisualImageModel toModel() {
        PadesVisualImageModel model = new PadesVisualImageModel();
        ResourceContentOrReference resource = new ResourceContentOrReference();
        resource.setMimeType(this.mimeType);
        if (this.content != null) {
            resource.setContent((String)new ObjectMapper().convertValue((Object)this.content, String.class));
        } else if (this.url != null) {
            resource.setUrl(this.url);
        } else {
            throw new IllegalStateException("The image content was not set, neither its URL");
        }
        model.setResource(resource);
        model.setOpacity(this.opacity);
        model.setHorizontalAlign(PadesVisualImageModel.HorizontalAlignEnum.valueOf(this.horizontalAlign.toString()));
        model.setVerticalAlign(PadesVisualImageModel.VerticalAlignEnum.valueOf(this.verticalAlign.toString()));
        return model;
    }
}

