/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.HorizontalDirections;
import com.lacunasoftware.pkiexpress.PadesMeasurementUnits;
import com.lacunasoftware.pkiexpress.PadesSize;
import com.lacunasoftware.pkiexpress.PadesVisualAutoPositioningModel;
import com.lacunasoftware.pkiexpress.PadesVisualPositioning;
import com.lacunasoftware.pkiexpress.PadesVisualPositioningModel;
import com.lacunasoftware.pkiexpress.PadesVisualRectangle;
import com.lacunasoftware.pkiexpress.VerticalDirections;

public class PadesVisualAutoPositioning
extends PadesVisualPositioning {
    private PadesVisualRectangle container;
    private PadesSize signatureRectangleSize;
    private double rowSpacing;
    private HorizontalDirections horizontalDirection;
    private VerticalDirections verticalDirection;

    public PadesVisualAutoPositioning() {
    }

    public PadesVisualAutoPositioning(int pageNumber, PadesMeasurementUnits measurementUnits, PadesVisualRectangle container, PadesSize signatureRectangleSize, double rowSpacing) {
        super(pageNumber, measurementUnits);
        this.container = container;
        this.signatureRectangleSize = signatureRectangleSize;
        this.rowSpacing = rowSpacing;
    }

    public PadesVisualRectangle getContainer() {
        return this.container;
    }

    public void setContainer(PadesVisualRectangle container) {
        this.container = container;
    }

    public PadesSize getSignatureRectangleSize() {
        return this.signatureRectangleSize;
    }

    public void setSignatureRectangleSize(PadesSize signatureRectangleSize) {
        this.signatureRectangleSize = signatureRectangleSize;
    }

    public double getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(double rowSpacing) {
        this.rowSpacing = rowSpacing;
    }

    public HorizontalDirections getHorizontalDirection() {
        return this.horizontalDirection;
    }

    public void setHorizontalDirection(HorizontalDirections horizontalDirection) {
        this.horizontalDirection = horizontalDirection;
    }

    public VerticalDirections getVerticalDirection() {
        return this.verticalDirection;
    }

    public void setVerticalDirection(VerticalDirections verticalDirection) {
        this.verticalDirection = verticalDirection;
    }

    @Override
    PadesVisualPositioningModel toModel() {
        PadesVisualPositioningModel model = super.toModel();
        PadesVisualAutoPositioningModel auto = new PadesVisualAutoPositioningModel();
        auto.setContainer(this.container.toModel());
        auto.setSignatureRectangleSize(this.signatureRectangleSize.toModel());
        auto.setRowSpacing(this.rowSpacing);
        if (this.horizontalDirection != null) {
            auto.setHorizontalDirection(PadesVisualAutoPositioningModel.HorizontalDirectionEnum.valueOf(this.horizontalDirection.toString()));
        }
        if (this.verticalDirection != null) {
            auto.setVerticalDirection(PadesVisualAutoPositioningModel.VerticalDirectionEnum.valueOf(this.verticalDirection.toString()));
        }
        model.setAuto(auto);
        return model;
    }
}

