/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class PadesTimestamper
extends PkiExpressOperator {
    private Path pdfPath;
    private Path outputFilePath;
    private boolean overwriteOriginalFile = false;

    public PadesTimestamper(PkiExpressConfig config) {
        super(config);
    }

    public PadesTimestamper() throws IOException {
        this(new PkiExpressConfig());
    }

    public Path getPdfPath() {
        return this.pdfPath;
    }

    public void setPdf(InputStream inputStream) throws IOException {
        this.pdfPath = this.writeToTempFile(inputStream);
    }

    public void setPdf(byte[] content) throws IOException {
        this.setPdf(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setPdf(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided PDF was not found");
        }
        this.pdfPath = path;
    }

    public void setPdf(String path) throws IOException {
        this.setPdf(path != null ? Paths.get(path, new String[0]) : null);
    }

    public Path getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(Path path) {
        this.outputFilePath = path;
    }

    public void setOutputFilePath(String path) {
        this.setOutputFilePath(path != null ? Paths.get(path, new String[0]) : null);
    }

    public boolean getOverwriteOriginalFile() {
        return this.overwriteOriginalFile;
    }

    public void setOverwriteOriginalFile(boolean overwriteOriginalFile) {
        this.overwriteOriginalFile = overwriteOriginalFile;
    }

    public void stamp() throws IOException {
        if (this.pdfPath == null) {
            throw new RuntimeException("The PDF to be timestamped was not set");
        }
        if (!this.overwriteOriginalFile && this.outputFilePath == null) {
            throw new RuntimeException("The output destination was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.pdfPath.toString());
        if (this.timestampAuthority != null) {
            args.addAll(this.timestampAuthority.getCmdArguments());
            this.versionManager.requireVersion(new Version("1.5"));
        }
        if (this.overwriteOriginalFile) {
            args.add("--overwrite");
        } else {
            args.add(this.outputFilePath.toString());
        }
        this.versionManager.requireVersion(new Version("1.7"));
        this.invoke(CommandEnum.CommandStampPdf, args);
    }
}

