/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.PadesCertificationLevel;
import com.lacunasoftware.pkiexpress.PadesVisualRepresentation;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureStartResult;
import com.lacunasoftware.pkiexpress.SignatureStarter;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class PadesSignatureStarter
extends SignatureStarter {
    private Path pdfToSignPath;
    private Path vrJsonPath;
    private boolean suppressDefaultVisualRepresentation = false;
    private String reason;
    private String customSignatureFieldName;
    private PadesCertificationLevel certificationLevel;

    public PadesSignatureStarter(PkiExpressConfig config) {
        super(config);
    }

    public PadesSignatureStarter() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setPdfToSign(InputStream inputStream) throws IOException {
        this.pdfToSignPath = this.writeToTempFile(inputStream);
    }

    public void setPdfToSign(byte[] content) throws IOException {
        this.setPdfToSign(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setPdfToSign(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided PDF to be signed was not found");
        }
        this.pdfToSignPath = path;
    }

    public void setPdfToSign(String path) throws IOException {
        this.setPdfToSign(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setVisualRepresentationFromFile(InputStream inputStream) throws IOException {
        this.vrJsonPath = this.writeToTempFile(inputStream);
    }

    public void setVisualRepresentationFromFile(byte[] content) throws IOException {
        this.setVisualRepresentationFromFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setVisualRepresentationFromFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided visual representation file was not found");
        }
        this.vrJsonPath = path;
    }

    public void setVisualRepresentationFromFile(String path) throws IOException {
        this.setVisualRepresentationFromFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setVisualRepresentation(PadesVisualRepresentation visualRepresentation) throws IOException {
        Path tempPath = this.createTempFile();
        FileOutputStream outputStream = new FileOutputStream(tempPath.toFile());
        new ObjectMapper().writeValue((OutputStream)outputStream, (Object)visualRepresentation.toModel());
        ((OutputStream)outputStream).close();
        this.vrJsonPath = tempPath;
    }

    public boolean isSuppressDefaultVisualRepresentation() {
        return this.suppressDefaultVisualRepresentation;
    }

    public void setSuppressDefaultVisualRepresentation(boolean suppressDefaultVisualRepresentation) {
        this.suppressDefaultVisualRepresentation = suppressDefaultVisualRepresentation;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getCustomSignatureFieldName() {
        return this.customSignatureFieldName;
    }

    public void setCustomSignatureFieldName(String customSignatureFieldName) {
        this.customSignatureFieldName = customSignatureFieldName;
    }

    public PadesCertificationLevel getCertificationLevel() {
        return this.certificationLevel;
    }

    public void setCertficationLevel(PadesCertificationLevel certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public SignatureStartResult start() throws IOException {
        if (this.pdfToSignPath == null) {
            throw new RuntimeException("The PDF to be signed was not set");
        }
        if (this.certificatePath == null) {
            throw new RuntimeException("The certificate was not set");
        }
        String transferFile = this.getTransferFileName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.pdfToSignPath.toString());
        args.add(this.certificatePath.toString());
        args.add(this.config.getTransferDataFolder().resolve(transferFile).toString());
        this.verifyAndAddCommonOptions(args);
        if (this.vrJsonPath != null) {
            args.add("--visual-rep");
            args.add(this.vrJsonPath.toString());
        }
        if (this.customSignatureFieldName != null) {
            args.add("--custom-signature-field-name");
            args.add(this.customSignatureFieldName);
            this.versionManager.requireVersion(new Version("1.15.0"));
        }
        if (this.certificationLevel != null) {
            args.add("--certification-level");
            args.add(this.certificationLevel.getValue());
            this.versionManager.requireVersion(new Version("1.16.0"));
        }
        if (!Util.isNullOrEmpty(this.reason)) {
            args.add("--reason");
            args.add(this.reason);
            this.versionManager.requireVersion(new Version("1.13.0"));
        }
        if (this.suppressDefaultVisualRepresentation) {
            args.add("--suppress-default-visual-rep");
            this.versionManager.requireVersion(new Version("1.13.1"));
        }
        String[] response = this.invokePlain(CommandEnum.CommandStartPades, args);
        return this.getResult(response, transferFile);
    }
}

