/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PadesSignature;
import com.lacunasoftware.pkiexpress.PadesSignatureModel;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureExplorer;
import com.lacunasoftware.pkiexpress.StandardSignaturePoliciesForValidation;
import com.lacunasoftware.pkiexpress.Version;
import java.io.IOException;
import java.util.ArrayList;

public class PadesSignatureExplorer
extends SignatureExplorer {
    private StandardSignaturePoliciesForValidation policy = null;

    public PadesSignatureExplorer(PkiExpressConfig config) {
        super(config);
    }

    public PadesSignatureExplorer() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setPolicy(StandardSignaturePoliciesForValidation policy) {
        this.policy = policy;
    }

    public PadesSignature open() throws IOException {
        if (this.signatureFilePath == null) {
            throw new RuntimeException("The provided signature file was not found");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.signatureFilePath.toString());
        this.verifyAndAddCommonOptions(args);
        if (this.policy != null) {
            args.add("--policy");
            args.add(this.policy.getValue());
            this.versionManager.requireVersion(new Version("1.20"));
        }
        this.versionManager.requireVersion(new Version("1.3"));
        OperatorResult result = this.invoke(CommandEnum.CommandOpenPades, args);
        PadesSignatureModel resultModel = this.parseOutput(result.getOutput()[0], PadesSignatureModel.class);
        return new PadesSignature(resultModel);
    }
}

