/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.PadesPageOptimizationModel;
import com.lacunasoftware.pkiexpress.PadesPageOrientation;
import com.lacunasoftware.pkiexpress.PadesPaperSize;
import com.lacunasoftware.pkiexpress.PadesSize;

public class PadesPageOptimization {
    private PadesPaperSize paperSize;
    private PadesSize customPaperSize;
    private PadesPageOrientation pageOrientation = PadesPageOrientation.Auto;

    public PadesPageOptimization() {
    }

    public PadesPageOptimization(PadesPaperSize paperSize) {
        this();
        this.paperSize = paperSize;
    }

    public PadesPageOptimization(PadesSize customPaperSize) {
        this();
        this.paperSize = PadesPaperSize.Custom;
        this.customPaperSize = customPaperSize;
    }

    public PadesPaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PadesPaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public PadesSize getCustomPaperSize() {
        return this.customPaperSize;
    }

    public void setCustomPaperSize(PadesSize customPaperSize) {
        this.customPaperSize = customPaperSize;
        this.paperSize = PadesPaperSize.Custom;
    }

    public PadesPageOrientation getPageOrientation() {
        return this.pageOrientation;
    }

    public void setPageOrientation(PadesPageOrientation pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public PadesPageOptimizationModel toModel() {
        PadesPageOptimizationModel model = new PadesPageOptimizationModel();
        if (this.paperSize != null) {
            model.setPaperSize(PadesPageOptimizationModel.PaperSizeEnum.valueOf(this.paperSize.toString()));
        }
        if (this.paperSize == PadesPaperSize.Custom) {
            if (this.customPaperSize != null) {
                model.setCustomPaperSize(this.customPaperSize.toModel());
            } else {
                throw new IllegalStateException("The paperSize is set to Custom but no customPaperSize was set");
            }
        }
        if (this.pageOrientation != null) {
            model.setPageOrientation(PadesPageOptimizationModel.PageOrientationEnum.valueOf(this.pageOrientation.toString()));
        }
        return model;
    }
}

