/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CertificateModel;
import com.lacunasoftware.pkiexpress.KeyUsage;
import com.lacunasoftware.pkiexpress.Name;
import com.lacunasoftware.pkiexpress.PkiBrazilCertificateFields;
import com.lacunasoftware.pkiexpress.PkiItalyCertificateFields;
import com.lacunasoftware.pkiexpress.Util;
import java.math.BigInteger;
import java.util.Date;

public class PKCertificate {
    private byte[] content;
    private Name subjectName;
    private String emailAddress;
    private Name issuerName;
    private BigInteger serialNumber;
    private Date validityStart;
    private Date validityEnd;
    private PkiBrazilCertificateFields pkiBrazil;
    private PkiItalyCertificateFields pkiItaly;
    private PKCertificate issuer;
    private byte[] binaryThumbprintSHA256;
    private String thumbprint;
    private KeyUsage keyUsage;

    PKCertificate(CertificateModel model) {
        this.content = Util.decodeBase64(model.getContent());
        this.subjectName = new Name(model.getSubjectName());
        this.emailAddress = model.getEmailAddress();
        this.issuerName = new Name(model.getIssuerName());
        this.serialNumber = new BigInteger(model.getSerialNumber());
        this.validityStart = model.getValidityStart();
        this.validityEnd = model.getValidityEnd();
        if (model.getPkiBrazil() != null) {
            this.pkiBrazil = new PkiBrazilCertificateFields(model.getPkiBrazil());
        }
        if (model.getPkiItaly() != null) {
            this.pkiItaly = new PkiItalyCertificateFields(model.getPkiItaly());
        }
        if (model.getIssuer() != null) {
            this.issuer = new PKCertificate(model.getIssuer());
        }
        this.binaryThumbprintSHA256 = Util.decodeBase64(model.getBinaryThumbprintSHA256());
        this.thumbprint = model.getThumbprint();
        if (model.getKeyUsage() != null) {
            this.keyUsage = new KeyUsage(model.getKeyUsage());
        }
    }

    public Name getSubjectName() {
        return this.subjectName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Name getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Date getValidityStart() {
        return this.validityStart;
    }

    public Date getValidityEnd() {
        return this.validityEnd;
    }

    public PkiBrazilCertificateFields getPkiBrazil() {
        return this.pkiBrazil;
    }

    public PkiItalyCertificateFields getPkiItaly() {
        return this.pkiItaly;
    }

    public PKCertificate getIssuer() {
        return this.issuer;
    }

    public byte[] getBinaryThumbprintSHA256() {
        return this.binaryThumbprintSHA256;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public KeyUsage getKeyUsage() {
        return this.keyUsage;
    }

    public void setKeyUsage(KeyUsage keyUsage) {
        this.keyUsage = keyUsage;
    }
}

