/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.KeyFormats;
import com.lacunasoftware.pkiexpress.KeyGenerationResult;
import com.lacunasoftware.pkiexpress.KeyGenerationResultModel;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Version;
import java.io.IOException;
import java.util.ArrayList;

public class KeyGenerator
extends PkiExpressOperator {
    private int keySize = 2048;
    private KeyFormats keyFormat = KeyFormats.JSON;
    private boolean genCsr = false;
    private final int[] SUPPORTED_KEY_SIZES = new int[]{1024, 2048, 4096};

    public KeyGenerator(PkiExpressConfig config) {
        super(config);
    }

    public KeyGenerator() throws IOException {
        this(new PkiExpressConfig());
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public KeyFormats getKeyFormat() {
        return this.keyFormat;
    }

    public void setKeyFormat(KeyFormats keyFormat) {
        this.keyFormat = keyFormat;
    }

    public boolean isGenCsr() {
        return this.genCsr;
    }

    public void setGenCsr(boolean genCsr) {
        this.genCsr = genCsr;
    }

    public KeyGenerationResult generate() throws IOException {
        return this.generate(this.keyFormat);
    }

    public KeyGenerationResult generate(KeyFormats keyFormat) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (!this.supportsKeySize(this.keySize)) {
            throw new IllegalStateException(String.format("Unsupported key size: %d", this.keySize));
        }
        args.add("--size");
        args.add(String.valueOf(this.keySize));
        if (this.keyFormat != null) {
            args.add("--format");
            args.add(keyFormat.getValue());
        }
        if (this.genCsr) {
            args.add("--gen-csr");
        }
        this.versionManager.requireVersion(new Version("1.11"));
        OperatorResult result = this.invoke(CommandEnum.CommandGenKey, args);
        KeyGenerationResultModel resultModel = this.parseOutput(result.getOutput()[0], KeyGenerationResultModel.class);
        return new KeyGenerationResult(resultModel);
    }

    private boolean supportsKeySize(int keySize) {
        boolean supports = false;
        for (int value : this.SUPPORTED_KEY_SIZES) {
            if (value != keySize) continue;
            supports = true;
            break;
        }
        return supports;
    }
}

