/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.DigestAlgorithmAndValueModel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum DigestAlgorithm {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private String name;

    private DigestAlgorithm(String name) {
        this.name = name;
    }

    static DigestAlgorithm getInstanceByApiModel(DigestAlgorithmAndValueModel.AlgorithmEnum model) {
        switch (model) {
            case MD5: {
                return MD5;
            }
            case SHA1: {
                return SHA1;
            }
            case SHA256: {
                return SHA256;
            }
            case SHA384: {
                return SHA384;
            }
            case SHA512: {
                return SHA512;
            }
        }
        throw new RuntimeException("Unsupported digest algorithm: " + (Object)((Object)model));
    }

    public String getName() {
        return this.name;
    }

    public MessageDigest getSpi() {
        try {
            return MessageDigest.getInstance(this.name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not get MessageDigest instance for algorithm " + this.name, e);
        }
    }

    DigestAlgorithmAndValueModel.AlgorithmEnum getDigestAlgorithmAndValueModelEnum() {
        switch (this) {
            case MD5: {
                return DigestAlgorithmAndValueModel.AlgorithmEnum.MD5;
            }
            case SHA1: {
                return DigestAlgorithmAndValueModel.AlgorithmEnum.SHA1;
            }
            case SHA256: {
                return DigestAlgorithmAndValueModel.AlgorithmEnum.SHA256;
            }
            case SHA384: {
                return DigestAlgorithmAndValueModel.AlgorithmEnum.SHA384;
            }
            case SHA512: {
                return DigestAlgorithmAndValueModel.AlgorithmEnum.SHA512;
            }
        }
        throw new RuntimeException();
    }
}

