/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CertificateModel;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PKCertificate;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class CertificateReader
extends PkiExpressOperator {
    private Path certPath;

    public CertificateReader(PkiExpressConfig config) {
        super(config);
    }

    public CertificateReader() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setCert(InputStream inputStream) throws IOException {
        this.certPath = this.writeToTempFile(inputStream);
    }

    public void setCert(byte[] content) throws IOException {
        this.setCert(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setCert(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided certificate was not found");
        }
        this.certPath = path;
    }

    public void setCert(String path) throws IOException {
        this.setCert(path != null ? Paths.get(path, new String[0]) : null);
    }

    public PKCertificate decode() throws IOException {
        if (this.certPath == null) {
            throw new RuntimeException("No certificate was provided");
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.certPath != null) {
            args.add("--file");
            args.add(this.certPath.toString());
        }
        OperatorResult result = this.invoke(CommandEnum.CommandReadCert, args);
        CertificateModel certificateModel = this.parseOutput(result.getOutput()[0], CertificateModel.class);
        return new PKCertificate(certificateModel);
    }
}

