/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CertificateExplorerModel;
import com.lacunasoftware.pkiexpress.CertificateExplorerResult;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class CertificateExplorer
extends PkiExpressOperator {
    private Path certificatePath;
    private boolean validate;
    private boolean fillContent;
    private boolean fillIssuer;

    public CertificateExplorer(PkiExpressConfig config) {
        super(config);
    }

    public CertificateExplorer() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setCertificate(InputStream inputStream) throws IOException {
        this.certificatePath = this.writeToTempFile(inputStream);
    }

    public void setCertificate(byte[] content) throws IOException {
        this.setCertificate(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setCertificate(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided certificate was not found");
        }
        this.certificatePath = path;
    }

    public void setCertificate(String path) throws IOException {
        this.setCertificate(Paths.get(path, new String[0]));
    }

    public void setCertificateBase64(String contentBase64) throws IOException {
        byte[] contentRaw = Util.decodeBase64(contentBase64);
        this.setCertificate(contentRaw);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean getFillContent() {
        return this.fillContent;
    }

    public void setFillContent(boolean fillContent) {
        this.fillContent = fillContent;
    }

    public boolean getFillIssuer() {
        return this.fillIssuer;
    }

    public void setFillIssuer(boolean fillIssuer) {
        this.fillIssuer = fillIssuer;
    }

    public CertificateExplorerResult open() throws IOException {
        if (this.certificatePath == null) {
            throw new RuntimeException("The certificate file was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--file");
        args.add(this.certificatePath.toString());
        if (this.validate) {
            args.add("--validate");
        }
        if (this.fillIssuer) {
            args.add("--fill-issuer");
            this.versionManager.requireVersion(new Version("1.22"));
        }
        if (this.fillContent) {
            args.add("--fill-content");
            this.versionManager.requireVersion(new Version("1.22"));
        }
        this.versionManager.requireVersion(new Version("1.20"));
        OperatorResult result = this.invoke(CommandEnum.CommandOpenCertificate, args);
        CertificateExplorerModel resultModel = this.parseOutput(result.getOutput()[0], CertificateExplorerModel.class);
        return new CertificateExplorerResult(resultModel);
    }
}

