/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CadesSignerModel;
import com.lacunasoftware.pkiexpress.CadesTimestamp;
import com.lacunasoftware.pkiexpress.CadesTimestampModel;
import com.lacunasoftware.pkiexpress.CertificateModel;
import com.lacunasoftware.pkiexpress.CommitmentType;
import com.lacunasoftware.pkiexpress.CommitmentTypeModel;
import com.lacunasoftware.pkiexpress.DigestAlgorithmAndValue;
import com.lacunasoftware.pkiexpress.DigestAlgorithmAndValueModel;
import com.lacunasoftware.pkiexpress.PKCertificate;
import com.lacunasoftware.pkiexpress.SignatureAlgorithmAndValueModel;
import com.lacunasoftware.pkiexpress.SignaturePolicyIdentifier;
import com.lacunasoftware.pkiexpress.SignaturePolicyIdentifierModel;
import com.lacunasoftware.pkiexpress.ValidationResults;
import com.lacunasoftware.pkiexpress.ValidationResultsModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CadesSignerInfo {
    private DigestAlgorithmAndValue messageDigest;
    private SignaturePolicyIdentifier signaturePolicy;
    private PKCertificate certificate;
    private Date signingTime;
    private Date certifiedDateReference;
    private List<CadesTimestamp> timestamps = new ArrayList<CadesTimestamp>();
    private ValidationResults validationResults;
    private CommitmentType commitmentType;

    CadesSignerInfo(DigestAlgorithmAndValueModel messageDigest, SignatureAlgorithmAndValueModel signature, CertificateModel certificate, Date signingTime, Date certifiedDateReference, SignaturePolicyIdentifierModel signaturePolicy, List<CadesTimestampModel> timestamps, ValidationResultsModel validationResults, CommitmentTypeModel commitmentType) {
        this.messageDigest = new DigestAlgorithmAndValue(messageDigest);
        this.certificate = new PKCertificate(certificate);
        this.signingTime = signingTime;
        this.certifiedDateReference = certifiedDateReference;
        if (signaturePolicy != null) {
            this.signaturePolicy = new SignaturePolicyIdentifier(signaturePolicy);
        }
        if (timestamps != null) {
            for (CadesTimestampModel timestampModel : timestamps) {
                this.timestamps.add(new CadesTimestamp(timestampModel));
            }
        }
        if (validationResults != null) {
            this.validationResults = new ValidationResults(validationResults);
        }
        if (commitmentType != null) {
            this.commitmentType = new CommitmentType(commitmentType);
        }
    }

    CadesSignerInfo(CadesSignerModel model) {
        this(model.getMessageDigest(), model.getSignature(), model.getCertificate(), model.getSigningTime(), model.getCertifiedDateReference(), model.getSignaturePolicy(), model.getTimestamps(), model.getValidationResults(), model.getCommitmentType());
    }

    public DigestAlgorithmAndValue getMessageDigest() {
        return this.messageDigest;
    }

    public SignaturePolicyIdentifier getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public PKCertificate getCertificate() {
        return this.certificate;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public Date getCertifiedDateReference() {
        return this.certifiedDateReference;
    }

    public List<CadesTimestamp> getTimestamps() {
        return this.timestamps;
    }

    public ValidationResults getValidationResults() {
        return this.validationResults;
    }

    public CommitmentType getCommitmentType() {
        return this.commitmentType;
    }
}

