/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PKCertificate;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureResult;
import com.lacunasoftware.pkiexpress.Signer;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class CadesSigner
extends Signer {
    private Path fileToSignPath;
    private Path dataFilePath;
    @Deprecated
    public Boolean encapsulateContent = true;

    public CadesSigner(PkiExpressConfig config) {
        super(config);
    }

    public CadesSigner() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setFileToSign(InputStream inputStream) throws IOException {
        this.fileToSignPath = this.writeToTempFile(inputStream);
    }

    public void setFileToSign(byte[] content) throws IOException {
        this.setFileToSign(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setFileToSign(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.fileToSignPath = path;
    }

    public void setFileToSign(String path) throws IOException {
        this.setFileToSign(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setDataFile(InputStream inputStream) throws IOException {
        this.dataFilePath = this.writeToTempFile(inputStream);
    }

    public void setDataFile(byte[] content) throws IOException {
        this.setDataFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setDataFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.dataFilePath = path;
    }

    public void setDataFile(String path) throws IOException {
        this.setDataFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public Boolean getEncapsulateContent() {
        return this.encapsulateContent;
    }

    public void setEncapsulateContent(Boolean encapsulateContent) {
        this.encapsulateContent = encapsulateContent;
    }

    public PKCertificate sign() throws IOException {
        return this.sign(false);
    }

    public PKCertificate sign(boolean getCert) throws IOException {
        if (this.fileToSignPath == null) {
            throw new RuntimeException("The file to be signed was not set");
        }
        if (this.outputFilePath == null) {
            throw new RuntimeException("The output destination was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.fileToSignPath.toString());
        args.add(this.outputFilePath.toString());
        this.verifyAndAddCommonOptions(args);
        if (this.dataFilePath != null) {
            args.add("--data-file");
            args.add(this.dataFilePath.toString());
        }
        if (!this.encapsulateContent.booleanValue()) {
            args.add("--detached");
        }
        if (getCert) {
            this.versionManager.requireVersion(new Version("1.8"));
            OperatorResult result = this.invoke(CommandEnum.CommandSignCades, args);
            SignatureResult resultModel = this.parseOutput(result.getOutput()[0], SignatureResult.class);
            return new PKCertificate(resultModel.getSigner());
        }
        this.invokePlain(CommandEnum.CommandSignCades, args);
        return null;
    }
}

