/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureStartResult;
import com.lacunasoftware.pkiexpress.SignatureStarter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class CadesSignatureStarter
extends SignatureStarter {
    private Path fileToSignPath;
    private Path dataFilePath;
    @Deprecated
    public Boolean encapsulateContent = true;

    public CadesSignatureStarter(PkiExpressConfig config) {
        super(config);
    }

    public CadesSignatureStarter() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setFileToSign(InputStream inputStream) throws IOException {
        this.fileToSignPath = this.writeToTempFile(inputStream);
    }

    public void setFileToSign(byte[] content) throws IOException {
        this.setFileToSign(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setFileToSign(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided file to be signed was not found");
        }
        this.fileToSignPath = path;
    }

    public void setFileToSign(String path) throws IOException {
        this.setFileToSign(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setDataFile(InputStream inputStream) throws IOException {
        this.dataFilePath = this.writeToTempFile(inputStream);
    }

    public void setDataFile(byte[] content) throws IOException {
        this.setDataFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setDataFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided data file was not found");
        }
        this.dataFilePath = path;
    }

    public void setDataFile(String path) throws IOException {
        this.setDataFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public Boolean getEncapsulateContent() {
        return this.encapsulateContent;
    }

    public void setEncapsulateContent(Boolean encapsulateContent) {
        this.encapsulateContent = encapsulateContent;
    }

    public SignatureStartResult start() throws IOException {
        if (this.fileToSignPath == null) {
            throw new RuntimeException("The file to be signed was not set");
        }
        if (this.certificatePath == null) {
            throw new RuntimeException("The certificate was not set");
        }
        String transferFile = this.getTransferFileName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.fileToSignPath.toString());
        args.add(this.certificatePath.toString());
        args.add(this.config.getTransferDataFolder().resolve(transferFile).toString());
        this.verifyAndAddCommonOptions(args);
        if (this.dataFilePath != null) {
            args.add("--data-file");
            args.add(this.dataFilePath.toString());
        }
        if (!this.encapsulateContent.booleanValue()) {
            args.add("--detached");
        }
        String[] response = this.invokePlain(CommandEnum.CommandStartCades, args);
        return this.getResult(response, transferFile);
    }
}

