/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CadesSignature;
import com.lacunasoftware.pkiexpress.CadesSignatureModel;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.SignatureExplorer;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class CadesSignatureExplorer
extends SignatureExplorer {
    private Path dataFilePath;
    private Path extractContentPath;

    public CadesSignatureExplorer(PkiExpressConfig config) {
        super(config);
    }

    public CadesSignatureExplorer() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setDataFile(InputStream inputStream) throws IOException {
        this.dataFilePath = this.writeToTempFile(inputStream);
    }

    public void setDataFile(byte[] content) throws IOException {
        this.setDataFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setDataFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided data file was not found");
        }
        this.dataFilePath = path;
    }

    public void setDataFile(String path) throws IOException {
        this.setDataFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public Path getExtractContentPath() {
        return this.extractContentPath;
    }

    public void setExtractContentPath(Path extractedContentPath) {
        this.extractContentPath = extractedContentPath;
    }

    public CadesSignature open() throws IOException {
        if (this.signatureFilePath == null) {
            throw new RuntimeException("The provided signature file was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.signatureFilePath.toString());
        this.verifyAndAddCommonOptions(args);
        if (this.dataFilePath != null) {
            args.add("--data-file");
            args.add(this.dataFilePath.toString());
        }
        if (this.extractContentPath != null) {
            args.add("--extract-content");
            args.add(this.extractContentPath.toString());
        }
        this.versionManager.requireVersion(new Version("1.3"));
        OperatorResult result = this.invoke(CommandEnum.CommandOpenCades, args);
        CadesSignatureModel resultModel = this.parseOutput(result.getOutput()[0], CadesSignatureModel.class);
        return new CadesSignature(resultModel);
    }
}

