/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class CadesSignatureEditor
extends PkiExpressOperator {
    private Path outputFilePath;
    private Path dataFilePath;
    private Boolean encapsulateContent = true;
    private List<Path> cmsFiles = new ArrayList<Path>();

    public CadesSignatureEditor(PkiExpressConfig config) {
        super(config);
    }

    public CadesSignatureEditor() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setDataFile(InputStream inputStream) throws IOException {
        this.dataFilePath = this.writeToTempFile(inputStream);
    }

    public void setDataFile(byte[] content) throws IOException {
        this.setDataFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setDataFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided data file was not found");
        }
        this.dataFilePath = path;
    }

    public void setDataFile(String path) throws IOException {
        this.setDataFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void setDataFileBase64(String contentBase64) throws IOException {
        byte[] contentRaw = Util.decodeBase64(contentBase64);
        this.setDataFile(contentRaw);
    }

    public Path getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(Path path) {
        this.outputFilePath = path;
    }

    public void setOutputFilePath(String path) {
        this.setOutputFilePath(path != null ? Paths.get(path, new String[0]) : null);
    }

    public Boolean getEncapsulateContent() {
        return this.encapsulateContent;
    }

    public void setEncapsulateContent(Boolean encapsulateContent) {
        this.encapsulateContent = encapsulateContent;
    }

    public List<Path> getCmsFiles() {
        return this.cmsFiles;
    }

    public void addCmsFile(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("The provided CMS File was not found");
        }
        this.cmsFiles.add(path);
    }

    public void addCmsFile(String path) {
        this.addCmsFile(path != null ? Paths.get(path, new String[0]) : null);
    }

    public void addCmsFile(InputStream inputStream) throws IOException {
        this.addCmsFile(this.writeToTempFile(inputStream));
    }

    public void addCmsFile(byte[] content) throws IOException {
        this.addCmsFile(new ByteArrayInputStream(content, 0, content.length));
    }

    public void addCmsFileBase64(String contentBase64) throws IOException {
        byte[] contentRaw = Util.decodeBase64(contentBase64);
        this.addCmsFile(contentRaw);
    }

    public void merge() throws IOException {
        if (this.cmsFiles == null || this.cmsFiles.isEmpty()) {
            throw new RuntimeException("Insufficient CMS/CAdES files for merging. Provided at least one signature.");
        }
        if (this.outputFilePath == null) {
            throw new RuntimeException("The output destination was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.outputFilePath.toString());
        if (this.cmsFiles.size() == 1) {
            this.versionManager.requireVersion(new Version("1.18"));
        }
        for (Path cmsFile : this.cmsFiles) {
            args.add(cmsFile.toString());
        }
        if (this.dataFilePath != null) {
            args.add("--data-file");
            args.add(this.dataFilePath.toString());
        }
        if (!this.encapsulateContent.booleanValue()) {
            args.add("--detached");
        }
        this.versionManager.requireVersion(new Version("1.9"));
        this.invoke(CommandEnum.CommandMergeCms, args);
    }
}

