/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.StandardSignaturePolicies;
import com.lacunasoftware.pkiexpress.Version;
import java.io.IOException;
import java.util.List;

class BaseSigner
extends PkiExpressOperator {
    BaseSigner(PkiExpressConfig config) {
        super(config);
    }

    BaseSigner() throws IOException {
        this(new PkiExpressConfig());
    }

    protected void verifyAndAddCommonOptions(List<String> args) {
        if (StandardSignaturePolicies.requireTimestamp(this.signaturePolicy) && this.timestampAuthority == null) {
            throw new RuntimeException("The provided policy requires a timestamp authority and none was provided");
        }
        if (this.signaturePolicy != null) {
            args.add("--policy");
            args.add(this.signaturePolicy.getValue());
            if (this.signaturePolicy != StandardSignaturePolicies.XmlDSigBasic && this.signaturePolicy != StandardSignaturePolicies.NFePadraoNacional) {
                this.versionManager.requireVersion(new Version("1.5"));
            }
            if (this.signaturePolicy == StandardSignaturePolicies.CodWithSHA1 || this.signaturePolicy == StandardSignaturePolicies.CodWithSHA256) {
                this.versionManager.requireVersion(new Version("1.6"));
            }
        }
        if (this.timestampAuthority != null) {
            args.addAll(this.timestampAuthority.getCmdArguments());
            this.versionManager.requireVersion(new Version("1.5"));
        }
    }
}

