/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.AuthCompleteModel;
import com.lacunasoftware.pkiexpress.AuthCompleteResult;
import com.lacunasoftware.pkiexpress.AuthStartModel;
import com.lacunasoftware.pkiexpress.AuthStartResult;
import com.lacunasoftware.pkiexpress.CommandEnum;
import com.lacunasoftware.pkiexpress.OperatorResult;
import com.lacunasoftware.pkiexpress.PkiExpressConfig;
import com.lacunasoftware.pkiexpress.PkiExpressOperator;
import com.lacunasoftware.pkiexpress.Util;
import com.lacunasoftware.pkiexpress.Version;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class Authentication
extends PkiExpressOperator {
    private String nonce;
    private Path certificatePath;
    private String signature;
    private boolean useExternalStorage = false;

    public Authentication(PkiExpressConfig config) {
        super(config);
    }

    public Authentication() throws IOException {
        this(new PkiExpressConfig());
    }

    public void setNonce(String nonceBase64) {
        try {
            Util.decodeBase64(nonceBase64);
        }
        catch (Exception ex) {
            throw new RuntimeException("The provided nonce was not valid");
        }
        this.nonce = nonceBase64;
    }

    public void setCertificate(InputStream inputStream) throws IOException {
        this.certificatePath = this.writeToTempFile(inputStream);
    }

    public void setCertificate(byte[] content) throws IOException {
        this.setCertificate(new ByteArrayInputStream(content, 0, content.length));
    }

    public void setCertificate(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The provided certificate was not found");
        }
        this.certificatePath = path;
    }

    public void setCertificate(String path) throws IOException {
        this.setCertificate(Paths.get(path, new String[0]));
    }

    public void setCertificateBase64(String contentBase64) throws IOException {
        byte[] contentRaw = Util.decodeBase64(contentBase64);
        this.setCertificate(contentRaw);
    }

    public void setSignature(String signatureBase64) {
        try {
            Util.decodeBase64(signatureBase64);
        }
        catch (Exception ex) {
            throw new RuntimeException("The provided signature was not valid");
        }
        this.signature = signatureBase64;
    }

    public void setExternalStorage(boolean useExternalStorage) {
        this.useExternalStorage = useExternalStorage;
    }

    public AuthStartResult start() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (!this.useExternalStorage) {
            args.add("--nonce-store");
            args.add(this.config.getTransferDataFolder().toString());
            this.versionManager.requireVersion(new Version("1.4"));
        }
        this.versionManager.requireVersion(new Version("1.4"));
        OperatorResult response = this.invoke(CommandEnum.CommandStartAuth, args);
        AuthStartModel model = this.parseOutput(response.getOutput()[0], AuthStartModel.class);
        return new AuthStartResult(model);
    }

    public AuthCompleteResult complete() throws IOException {
        if (this.nonce == null) {
            throw new RuntimeException("The nonce was not set");
        }
        if (this.certificatePath == null) {
            throw new RuntimeException("The certificate file was not set");
        }
        if (this.signature == null) {
            throw new RuntimeException("The signature was not set");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.nonce);
        args.add(this.certificatePath.toString());
        args.add(this.signature);
        if (!this.useExternalStorage) {
            args.add("--nonce-store");
            args.add(this.config.getTransferDataFolder().toString());
            this.versionManager.requireVersion(new Version("1.4"));
        }
        this.versionManager.requireVersion(new Version("1.4"));
        OperatorResult response = this.invoke(CommandEnum.CommandCompleteAuth, args);
        AuthCompleteModel model = this.parseOutput(response.getOutput()[0], AuthCompleteModel.class);
        return new AuthCompleteResult(model);
    }
}

