/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.pkiexpress;

import com.lacunasoftware.pkiexpress.Util;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.BitSet;

public class AlphaCode {
    private static final SecureRandom rng = new SecureRandom();
    private static final String alphabet = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
    private static int defaultSize = 16;

    public static String generate() {
        return AlphaCode.generate(defaultSize);
    }

    public static String generate(int codeSize) {
        byte[] bytes = new byte[(int)Math.ceil((double)(codeSize * 5) / 8.0)];
        rng.nextBytes(bytes);
        BitSet bits = BitSet.valueOf(bytes);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < codeSize; ++i) {
            int n = (bits.get(i * 5) ? 1 : 0) << 4 | (bits.get(i * 5 + 1) ? 1 : 0) << 3 | (bits.get(i * 5 + 2) ? 1 : 0) << 2 | (bits.get(i * 5 + 3) ? 1 : 0) << 1 | (bits.get(i * 5 + 4) ? 1 : 0);
            sb.append(alphabet.charAt(n));
        }
        return sb.toString();
    }

    public static String format(String code) {
        int nGroups;
        if (code == null) {
            throw new IllegalArgumentException("code");
        }
        code = code.trim();
        switch (code.length()) {
            case 8: {
                nGroups = 2;
                break;
            }
            case 9: {
                nGroups = 3;
                break;
            }
            case 10: {
                nGroups = 2;
                break;
            }
            case 12: {
                nGroups = 3;
                break;
            }
            case 15: {
                nGroups = 3;
                break;
            }
            case 16: {
                nGroups = 4;
                break;
            }
            case 20: {
                nGroups = 5;
                break;
            }
            case 24: {
                nGroups = 6;
                break;
            }
            case 25: {
                nGroups = 5;
                break;
            }
            case 28: {
                nGroups = 7;
                break;
            }
            case 30: {
                nGroups = 6;
                break;
            }
            default: {
                nGroups = 1;
            }
        }
        return AlphaCode.format(code, nGroups);
    }

    public static String format(String code, int nGroups) {
        if (code == null) {
            throw new IllegalArgumentException("code");
        }
        if (nGroups < 1) {
            throw new IllegalArgumentException("The parameter \"nGroups\" must be >= 1");
        }
        if (nGroups == 1 || code.length() % nGroups != 0) {
            return code;
        }
        int charsPerGroup = code.length() / nGroups;
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < charsPerGroup; ++i) {
            groups.add(code.substring(i * charsPerGroup, (i + 1) * charsPerGroup));
        }
        return Util.join("-", groups);
    }

    public static String parse(String formattedCode) {
        if (formattedCode == null) {
            throw new IllegalArgumentException("formattedCode");
        }
        return formattedCode.replaceAll("[^A-Za-z0-9]", "");
    }

    public static int getDefaultSize() {
        return defaultSize;
    }

    public static void setDefaultSize(int defaultSize) {
        AlphaCode.defaultSize = defaultSize;
    }
}

