/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.net.Authenticator;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import kong.unirest.core.Config;
import kong.unirest.core.Proxy;
import kong.unirest.core.UnirestConfigException;
import kong.unirest.core.java.NeverUseInProdTrustManager;
import kong.unirest.core.java.SSLContextBuilder;

class JavaClientBuilder
implements Function<Config, HttpClient> {
    JavaClientBuilder() {
    }

    @Override
    public HttpClient apply(Config config) {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(this.redirectPolicy(config)).connectTimeout(Duration.ofMillis(config.getConnectionTimeout()));
        this.configureTLSOptions(config, builder);
        if (config.getVersion() != null) {
            builder.version(config.getVersion());
        }
        if (config.getCustomExecutor() != null) {
            builder.executor(config.getCustomExecutor());
        }
        if (config.getEnabledCookieManagement()) {
            builder = builder.cookieHandler(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        if (config.getProxy() != null) {
            this.createProxy(builder, config.getProxy());
        }
        if (config.useSystemProperties()) {
            builder.proxy(ProxySelector.getDefault());
        }
        return builder.build();
    }

    private void configureTLSOptions(Config config, HttpClient.Builder builder) {
        SSLParameters params = new SSLParameters();
        if (!config.isVerifySsl()) {
            builder.sslContext(NeverUseInProdTrustManager.create());
        } else if (config.getKeystore() != null) {
            builder.sslContext(this.getSslContext(config));
        } else if (config.getSslContext() != null) {
            builder.sslContext(config.getSslContext());
        }
        if (config.getProtocols() != null) {
            params.setProtocols(config.getProtocols());
        }
        if (config.getCiphers() != null) {
            params.setCipherSuites(config.getCiphers());
        }
        builder.sslParameters(params);
    }

    private void createProxy(HttpClient.Builder builder, final Proxy proxy) {
        InetSocketAddress address = InetSocketAddress.createUnresolved(proxy.getHost(), proxy.getPort());
        builder.proxy(ProxySelector.of(address));
        if (proxy.isAuthenticated()) {
            builder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxy.getUsername(), proxy.getPassword().toCharArray());
                }
            });
        }
    }

    private SSLContext getSslContext(Config config) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(config.getKeystore());
            char[] pass = Optional.ofNullable(config.getKeyStorePassword()).map(String::toCharArray).orElse(null);
            return SSLContextBuilder.create().loadKeyMaterial(config.getKeystore(), pass).build();
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }

    private HttpClient.Redirect redirectPolicy(Config config) {
        if (config.getFollowRedirects()) {
            return HttpClient.Redirect.NORMAL;
        }
        return HttpClient.Redirect.NEVER;
    }
}

