/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.spi.helpers;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityFieldPrototype;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.internal.validators.AncestorsValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.ChangeValidatorAdapter;
import com.kenshoo.pl.entity.internal.validators.EntityChangeValidator;
import com.kenshoo.pl.entity.internal.validators.EntityChangeValidatorAdapter;
import com.kenshoo.pl.entity.internal.validators.FieldComplexValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.FieldValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.FieldsCombinationValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.ImmutableFieldValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.PrototypeFieldComplexValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.PrototypeFieldValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.PrototypeFieldsCombinationValidationAdapter;
import com.kenshoo.pl.entity.internal.validators.RequiredFieldValidationAdapter;
import com.kenshoo.pl.entity.spi.AncestorsValidator;
import com.kenshoo.pl.entity.spi.ChangesValidator;
import com.kenshoo.pl.entity.spi.FieldComplexValidator;
import com.kenshoo.pl.entity.spi.FieldValidator;
import com.kenshoo.pl.entity.spi.FieldsCombinationValidator;
import com.kenshoo.pl.entity.spi.ImmutableFieldValidator;
import com.kenshoo.pl.entity.spi.PrototypeFieldComplexValidator;
import com.kenshoo.pl.entity.spi.PrototypeFieldValidator;
import com.kenshoo.pl.entity.spi.PrototypeFieldsCombinationValidator;
import com.kenshoo.pl.entity.spi.RequiredFieldValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityChangeCompositeValidator<E extends EntityType<E>>
implements ChangesValidator<E> {
    private final List<ChangeValidatorAdapter<E>> triggeredChangeValidators = new ArrayList<ChangeValidatorAdapter<E>>();

    public void register(FieldsCombinationValidator<E> validator) {
        this.register(new FieldsCombinationValidationAdapter<E>(validator));
    }

    public <T> void register(FieldValidator<E, T> validator) {
        this.register(new FieldValidationAdapter<E, T>(validator));
    }

    public <T> void register(FieldComplexValidator<E, T> validator) {
        this.register(new FieldComplexValidationAdapter<E, T>(validator));
    }

    public <T> void register(ImmutableFieldValidator<E, T> validator) {
        this.register(new ImmutableFieldValidationAdapter<E, T>(validator));
    }

    public <T> void register(RequiredFieldValidator<E, T> validator) {
        this.register(new RequiredFieldValidationAdapter<E, T>(validator));
    }

    public void register(AncestorsValidator validator) {
        this.register(new AncestorsValidationAdapter(validator));
    }

    public void register(EntityChangeValidator<E> validator) {
        this.register(new EntityChangeValidatorAdapter<E>(validator));
    }

    public <T> void register(E entityType, PrototypeFieldValidator<T> validator) {
        Set<EntityField<E, T>> entityFields = EntityTypeReflectionUtil.getFieldsByPrototype(entityType, validator.getPrototype());
        if (entityFields.isEmpty()) {
            throw new IllegalArgumentException("Can not find entity field by prototype: " + validator.getPrototype());
        }
        for (EntityField<E, T> entityField : entityFields) {
            this.register(new PrototypeFieldValidationAdapter<E, T>(entityField, validator));
        }
    }

    public void register(E entityType, PrototypeFieldsCombinationValidator validator) {
        Map<EntityFieldPrototype<?>, EntityField<E, ?>> fieldMapping = EntityTypeReflectionUtil.getFieldMappingByPrototype(entityType, validator.getPrototypes());
        if (fieldMapping.size() == validator.getPrototypes().size()) {
            this.register(new PrototypeFieldsCombinationValidationAdapter<E>(validator, fieldMapping));
        } else {
            for (EntityFieldPrototype<?> entityFieldPrototype : validator.getPrototypes()) {
                if (fieldMapping.containsKey(entityFieldPrototype)) continue;
                throw new IllegalArgumentException("Can not find entity field by prototype: " + entityFieldPrototype);
            }
        }
    }

    public <T> void register(E entityType, PrototypeFieldComplexValidator<T> validator) {
        Set<EntityField<E, T>> entityFields = EntityTypeReflectionUtil.getFieldsByPrototype(entityType, validator.getPrototype());
        if (entityFields.isEmpty()) {
            throw new IllegalArgumentException("Can not find entity field by prototype: " + validator.getPrototype());
        }
        for (EntityField<E, T> entityField : entityFields) {
            this.register(new PrototypeFieldComplexValidationAdapter<E, T>(entityField, validator));
        }
    }

    @Override
    public void validate(Collection<? extends EntityChange<E>> entityChanges, ChangeOperation changeOperation, ChangeContext changeContext) {
        entityChanges.forEach(entityChange -> {
            CurrentEntityState currentState = changeContext.getEntity((EntityChange)entityChange);
            Collection fieldsToUpdate = entityChange.getChangedFields().collect(Collectors.toList());
            this.findValidatorsTriggeredByFields(fieldsToUpdate, changeOperation).map(validator -> validator.validate(entityChange, currentState)).filter(Objects::nonNull).forEach(validationError -> changeContext.addValidationError((EntityChange<? extends EntityType<?>>)entityChange, (ValidationError)validationError));
        });
    }

    @Override
    public Stream<EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
        return this.findValidatorsTriggeredByFields(fieldsToUpdate, changeOperation).flatMap(ChangeValidatorAdapter::fieldsToFetch);
    }

    public void register(ChangeValidatorAdapter<E> validatorAdapter) {
        this.triggeredChangeValidators.add(validatorAdapter);
    }

    private Stream<ChangeValidatorAdapter<E>> findValidatorsTriggeredByFields(Collection<? extends EntityField<E, ?>> entityFields, ChangeOperation changeOperation) {
        return this.triggeredChangeValidators.stream().filter(triggeredValidator -> triggeredValidator.trigger().triggeredByFields(entityFields)).filter(triggeredValidator -> triggeredValidator.getSupportedChangeOperation().supports(changeOperation));
    }
}

