/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.validators;

import com.google.common.collect.ImmutableMap;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.validators.ChangeValidatorAdapter;
import com.kenshoo.pl.entity.internal.validators.FieldTrigger;
import com.kenshoo.pl.entity.internal.validators.ValidationTrigger;
import com.kenshoo.pl.entity.spi.ImmutableFieldValidator;
import java.util.Map;
import java.util.stream.Stream;

public class ImmutableFieldValidationAdapter<E extends EntityType<E>, T>
implements ChangeValidatorAdapter<E> {
    private final ImmutableFieldValidator<E, T> validator;
    private final ValidationTrigger<E> trigger;

    public ImmutableFieldValidationAdapter(ImmutableFieldValidator<E, T> validator) {
        this.validator = validator;
        this.trigger = new FieldTrigger<E>(validator.immutableField());
    }

    @Override
    public ValidationTrigger<E> trigger() {
        return this.trigger;
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.UPDATE;
    }

    @Override
    public Stream<? extends EntityField<?, ?>> fieldsToFetch() {
        Stream<EntityField<?, ?>> fetchFields = this.validator.fetchFields();
        if (fetchFields != null) {
            return Stream.concat(Stream.of(this.validator.immutableField()), this.validator.fetchFields());
        }
        return Stream.of(this.validator.immutableField());
    }

    @Override
    public ValidationError validate(EntityChange<E> entityChange, CurrentEntityState currentState) {
        if (entityChange.isFieldChanged(this.validator.immutableField()) && this.validator.immutableWhen().test(currentState)) {
            return new ValidationError(this.validator.getErrorCode(), this.validator.immutableField(), (Map<String, String>)ImmutableMap.of((Object)"field", (Object)this.validator.immutableField().toString()));
        }
        return null;
    }
}

