/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.fetch;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kenshoo.jooq.DataTable;
import com.kenshoo.jooq.QueryExtension;
import com.kenshoo.jooq.SelectQueryExtender;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.internal.fetch.OneToOneTableRelation;
import com.kenshoo.pl.entity.internal.fetch.TreeEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFinalStep;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.True;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.lambda.function.Functions;

public class QueryBuilder<E extends EntityType<E>> {
    private final QueryExtender DONT_EXTEND_WITH_IDS = this::dontExtend;
    private DSLContext dslContext;
    private List<SelectField<?>> selectedFields;
    private DataTable startingTable;
    private List<TreeEdge> paths = Collections.emptyList();
    private Set<OneToOneTableRelation> oneToOneTableRelations = Collections.emptySet();
    private Condition condition = DSL.trueCondition();
    private Partitioner partitioner = this::addPartitionToCondition;
    private QueryExtender queryExtender = this.DONT_EXTEND_WITH_IDS;
    private final Partitioner NO_PARTITION = (table, cond) -> cond;

    public QueryBuilder(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public QueryBuilder<E> selecting(List<SelectField<?>> selectedFields) {
        this.selectedFields = selectedFields;
        return this;
    }

    public QueryBuilder<E> from(DataTable primaryTable) {
        this.startingTable = primaryTable;
        return this;
    }

    public QueryBuilder<E> innerJoin(List<TreeEdge> paths) {
        this.paths = paths;
        return this;
    }

    public QueryBuilder<E> innerJoin(TreeEdge path) {
        this.paths = Lists.newArrayList((Object[])new TreeEdge[]{path});
        return this;
    }

    public QueryBuilder<E> leftJoin(Set<OneToOneTableRelation> oneToOneTableRelations) {
        this.oneToOneTableRelations = oneToOneTableRelations;
        return this;
    }

    public QueryBuilder<E> whereIdsIn(Collection<? extends Identifier<? extends EntityType<?>>> ids) {
        if (this.queryExtender != this.DONT_EXTEND_WITH_IDS) {
            throw new IllegalStateException("We currently support only a single query extension");
        }
        this.queryExtender = query -> this.addIdCondition(query, ids);
        return this;
    }

    public QueryBuilder<E> withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public QueryBuilder<E> withoutPartitions() {
        this.partitioner = this.NO_PARTITION;
        return this;
    }

    public QueryExtension<SelectFinalStep<Record>> build() {
        SelectJoinStep query = this.dslContext.select(this.selectedFields).from((TableLike)this.startingTable);
        HashSet joinedTables = Sets.newHashSet((Object[])new DataTable[]{this.startingTable});
        this.paths.forEach(edge -> QueryBuilder.joinTables((SelectJoinStep<Record>)query, joinedTables, edge));
        QueryBuilder.joinSecondaryTables((SelectJoinStep<Record>)query, joinedTables, this.oneToOneTableRelations);
        this.condition = this.partitioner.transform(this.startingTable, this.condition);
        query.where(this.condition);
        return this.queryExtender.transform((SelectFinalStep<Record>)query);
    }

    static void joinTables(SelectJoinStep<Record> query, Set<DataTable> alreadyJoinedTables, TreeEdge edgeInThePath) {
        LinkedList<TreeEdge> joins = new LinkedList<TreeEdge>();
        joins.push(edgeInThePath);
        while (!alreadyJoinedTables.contains(edgeInThePath.source.table)) {
            edgeInThePath = edgeInThePath.source.parent;
            joins.push(edgeInThePath);
        }
        for (TreeEdge join : joins) {
            DataTable rhs = join.target.table;
            query.join((TableLike)rhs).on(QueryBuilder.getJoinCondition(join.source.table, join.target.table));
            alreadyJoinedTables.add(rhs);
        }
    }

    static void joinSecondaryTables(SelectJoinStep<Record> query, Set<? extends Table<Record>> alreadyJoinedTables, Set<OneToOneTableRelation> targetOneToOneRelations) {
        targetOneToOneRelations.stream().filter(Functions.not(QueryBuilder.secondaryTableIn(alreadyJoinedTables))).forEach(QueryBuilder.addLeftJoinTo(query));
    }

    private static Condition getJoinCondition(Table<Record> fromTable, Table<Record> toTable) {
        List foreignKeys = toTable.getReferencesTo(fromTable);
        if (foreignKeys.isEmpty()) {
            foreignKeys = fromTable.getReferencesTo(toTable);
        }
        if (foreignKeys.isEmpty()) {
            return null;
        }
        True joinCondition = DSL.trueCondition();
        ForeignKey foreignKey = (ForeignKey)foreignKeys.get(0);
        UniqueKey key = foreignKey.getKey();
        List otherTableFields = key.getFields();
        for (int i = 0; i < foreignKey.getFields().size(); ++i) {
            TableField tableField = (TableField)foreignKey.getFields().get(i);
            joinCondition = joinCondition.and(tableField.eq((Field)((TableField)otherTableFields.get(i))));
        }
        return joinCondition;
    }

    private Condition addPartitionToCondition(DataTable table, Condition inputJooqCondition) {
        return table.getVirtualPartition().stream().map(fv -> fv).map(fieldAndValue -> fieldAndValue.getField().eq(fieldAndValue.getValue())).reduce(inputJooqCondition, Condition::and);
    }

    private static Predicate<OneToOneTableRelation> secondaryTableIn(Set<? extends Table<Record>> joinedTables) {
        return relation -> joinedTables.contains(relation.getSecondary());
    }

    private static Consumer<OneToOneTableRelation> addLeftJoinTo(SelectJoinStep<Record> query) {
        return relation -> query.leftOuterJoin(relation.getSecondary()).on(QueryBuilder.getJoinCondition(relation));
    }

    private static Condition getJoinCondition(OneToOneTableRelation relation) {
        return QueryBuilder.getJoinCondition(relation.getSecondary(), relation.getPrimary());
    }

    private QueryExtension<SelectFinalStep<Record>> dontExtend(final SelectFinalStep<Record> query) {
        return new QueryExtension<SelectFinalStep<Record>>(){

            @Override
            public SelectFinalStep<Record> getQuery() {
                return query;
            }

            @Override
            public void close() {
            }
        };
    }

    private <I extends EntityType<I>, ID extends Identifier<I>> QueryExtension<SelectFinalStep<Record>> addIdCondition(SelectFinalStep query, Collection<? extends ID> ids) {
        return SelectQueryExtender.of(this.dslContext, query, Identifier.groupValuesByFields(ids));
    }

    private static interface QueryExtender {
        public QueryExtension<SelectFinalStep<Record>> transform(SelectFinalStep<Record> var1);
    }

    private static interface Partitioner {
        public Condition transform(DataTable var1, Condition var2);
    }
}

