/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.annotation.audit.Audited;
import com.kenshoo.pl.entity.audit.ExternalAuditedField;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import com.kenshoo.pl.entity.spi.audit.AuditExtensions;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalMandatoryFieldsExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ExternalMandatoryFieldsExtractor.class);
    static final ExternalMandatoryFieldsExtractor INSTANCE = new ExternalMandatoryFieldsExtractor();

    public Stream<? extends AuditedField<?, ?>> extract(EntityType<?> entityType) {
        return Optional.ofNullable(entityType.getClass().getAnnotation(Audited.class)).map(Audited::extensions).flatMap(this::createExtensions).map(AuditExtensions::externalMandatoryFields).map(fields -> fields.map(this::toAuditedField)).orElse(Stream.empty());
    }

    private Optional<AuditExtensions> createExtensions(Class<? extends AuditExtensions> extensionsClass) {
        try {
            return Optional.of(extensionsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to create an instance of type {} - either it doesn't have a no-arg constructor, or the constructor is not public. The corresponding fields will not be included in the audit records.", extensionsClass, (Object)e);
            return Optional.empty();
        }
    }

    private AuditedField<?, ?> toAuditedField(ExternalAuditedField<?, ?> externalAuditedField) {
        return AuditedField.builder(externalAuditedField.getField()).withName(externalAuditedField.getName()).build();
    }
}

