/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.annotation.audit.Audited;
import com.kenshoo.pl.entity.audit.AuditTrigger;
import com.kenshoo.pl.entity.internal.audit.AuditIndicator;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityType;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityTypeNameResolver;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityTypeResolver;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import com.kenshoo.pl.entity.internal.audit.AuditedFieldResolver;
import com.kenshoo.pl.entity.internal.audit.ExternalMandatoryFieldsExtractor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AuditedEntityTypeResolverImpl
implements AuditedEntityTypeResolver {
    public static final AuditedEntityTypeResolverImpl INSTANCE = new AuditedEntityTypeResolverImpl(AuditedEntityTypeNameResolver.INSTANCE, AuditedFieldResolver.INSTANCE, ExternalMandatoryFieldsExtractor.INSTANCE);
    private final AuditedEntityTypeNameResolver auditedEntityTypeNameResolver;
    private final AuditedFieldResolver auditedFieldResolver;
    private final ExternalMandatoryFieldsExtractor externalMandatoryFieldsExtractor;

    @VisibleForTesting
    AuditedEntityTypeResolverImpl(AuditedEntityTypeNameResolver auditedEntityTypeNameResolver, AuditedFieldResolver auditedFieldResolver, ExternalMandatoryFieldsExtractor externalMandatoryFieldsExtractor) {
        this.auditedEntityTypeNameResolver = auditedEntityTypeNameResolver;
        this.auditedFieldResolver = auditedFieldResolver;
        this.externalMandatoryFieldsExtractor = externalMandatoryFieldsExtractor;
    }

    @Override
    public <E extends EntityType<E>> Optional<AuditedEntityType<E>> resolve(E entityType) {
        Objects.requireNonNull(entityType, "entityType is required");
        return entityType.getIdField().flatMap(idField -> this.resolve(entityType, (EntityField)idField));
    }

    private <E extends EntityType<E>> Optional<AuditedEntityType<E>> resolve(E entityType, EntityField<E, ? extends Number> idField) {
        AuditIndicator entityAuditIndicator = entityType.getClass().isAnnotationPresent(Audited.class) ? AuditIndicator.AUDITED : AuditIndicator.NOT_AUDITED;
        Stream<? extends AuditedField<?, ?>> externalFields = this.externalMandatoryFieldsExtractor.extract(entityType);
        Map<AuditTrigger, List<AuditedField<E, ?>>> internalFields = this.resolveInternalFields(entityType, idField, entityAuditIndicator);
        AuditedEntityType<E> auditedEntityType = AuditedEntityType.builder(idField).withName(this.auditedEntityTypeNameResolver.resolve(entityType)).withExternalFields(externalFields).withInternalFields(internalFields).build();
        if (entityAuditIndicator == AuditIndicator.AUDITED || auditedEntityType.hasInternalFields()) {
            return Optional.of(auditedEntityType);
        }
        return Optional.empty();
    }

    private <E extends EntityType<E>> Map<AuditTrigger, List<AuditedField<E, ?>>> resolveInternalFields(E entityType, EntityField<E, ? extends Number> idField, AuditIndicator entityAuditIndicator) {
        return entityType.getFields().filter(field -> !idField.equals(field)).map(field -> this.auditedFieldResolver.resolve(field, entityAuditIndicator)).flatMap(Optional::stream).collect(Collectors.groupingBy(AuditedField::getTrigger, Collectors.toUnmodifiableList()));
    }
}

