/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.annotation.audit.Audited;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AuditedEntityTypeNameResolver {
    static final AuditedEntityTypeNameResolver INSTANCE = new AuditedEntityTypeNameResolver();

    public String resolve(EntityType<?> entityType) {
        Objects.requireNonNull(entityType, "entityType is required");
        return Optional.ofNullable(entityType.getClass().getAnnotation(Audited.class)).map(Audited::name).filter(StringUtils::isNotBlank).orElse(entityType.getName());
    }

    private AuditedEntityTypeNameResolver() {
    }
}

