/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FinalEntityState;
import com.kenshoo.pl.entity.Triptional;
import com.kenshoo.pl.entity.internal.Triptionals;
import java.util.Objects;
import java.util.Optional;

public class EntityIdExtractor {
    public static final EntityIdExtractor INSTANCE = new EntityIdExtractor();

    public <E extends EntityType<E>> Optional<String> extract(EntityChange<E> entityChange, CurrentEntityState currentState) {
        Objects.requireNonNull(entityChange, "entityChange is required");
        Objects.requireNonNull(currentState, "currentState is required");
        return entityChange.getEntityType().getIdField().flatMap(idField -> this.extract(entityChange, currentState, (EntityField)idField));
    }

    private <E extends EntityType<E>, T> Optional<String> extract(EntityChange<E> entityChange, CurrentEntityState currentState, EntityField<E, T> idField) {
        return Triptionals.firstPresent(() -> this.extractFromIdentifier(entityChange, idField), () -> new FinalEntityState(currentState, entityChange).safeGet(idField)).mapToOptional(String::valueOf);
    }

    private <E extends EntityType<E>, T> Triptional<T> extractFromIdentifier(EntityChange<E> entityChange, EntityField<E, T> idField) {
        return Triptional.of(entityChange.getIdentifier()).flatMap(identifier -> identifier.safeGet(idField), Triptional::absent);
    }

    private EntityIdExtractor() {
    }
}

