/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.ImmutableList;
import com.kenshoo.pl.entity.Entity;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.IdentifierType;
import com.kenshoo.pl.entity.UniqueKeyValue;
import java.util.Arrays;
import java.util.List;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.lambda.Seq;

public class UniqueKey<E extends EntityType<E>>
implements IdentifierType<E> {
    private final EntityField<E, ?>[] fields;
    private final TableField<Record, ?>[] tableFields;
    private int hashCode;

    public UniqueKey(EntityField<E, ?>[] fields) {
        this.fields = fields;
        this.tableFields = (TableField[])Arrays.asList(fields).stream().flatMap(field -> field.getDbAdapter().getTableFields()).toArray(TableField[]::new);
    }

    public UniqueKey(Iterable<? extends EntityField<E, ?>> fields) {
        this((EntityField[])Seq.seq(fields).toArray(EntityField[]::new));
    }

    @Override
    public EntityField<E, ?>[] getFields() {
        return this.fields;
    }

    @Override
    public List<TableField<Record, ?>> getTableFields() {
        return ImmutableList.copyOf((Object[])this.tableFields);
    }

    @Override
    public Identifier<E> createIdentifier(FieldsValueMap<E> fieldsValueMap) {
        Object[] values = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            values[i] = fieldsValueMap.get(this.fields[i]);
        }
        return new UniqueKeyValue(this, values);
    }

    @Override
    public Identifier<E> createIdentifier(Entity entity) {
        Object[] values = Seq.of((Object[])this.fields).map(entity::get).toArray();
        return new UniqueKeyValue(this, values);
    }

    @Override
    public E getEntityType() {
        if (this.fields.length == 0) {
            throw new IllegalStateException("unique key does not contain any fields.");
        }
        return (E)this.fields[0].getEntityType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniqueKey)) {
            return false;
        }
        UniqueKey uniqueKey = (UniqueKey)o;
        return Arrays.deepEquals(this.fields, uniqueKey.fields);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.deepHashCode(this.fields);
        }
        return this.hashCode;
    }

    public String toString() {
        return "UniqueKey{fields=" + Arrays.toString(this.fields) + "}";
    }
}

