/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.kenshoo.pl.entity.Entity;
import com.kenshoo.pl.entity.EntityField;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jooq.Condition;
import org.jooq.impl.DSL;

public class PLCondition {
    private final Condition jooqCondition;
    private final Predicate<Entity> postFetchCondition;
    private final Set<? extends EntityField<?, ?>> fields;

    public PLCondition(Condition jooqCondition, Predicate<Entity> postFetchCondition, EntityField<?, ?> ... fields) {
        this(jooqCondition, postFetchCondition, (Set<? extends EntityField<?, ?>>)ImmutableSet.copyOf((Object[])fields));
    }

    public PLCondition(Condition jooqCondition, Predicate<Entity> postFetchCondition, Set<? extends EntityField<?, ?>> fields) {
        this.jooqCondition = Objects.requireNonNull(jooqCondition, "a Jooq condition must be provided");
        this.postFetchCondition = Objects.requireNonNull(postFetchCondition, "a post fetch condition must be provided");
        this.fields = Objects.requireNonNull(fields, "Fields must not be null (can be empty)");
    }

    public Condition getJooqCondition() {
        return this.jooqCondition;
    }

    public Predicate<Entity> getPostFetchCondition() {
        return this.postFetchCondition;
    }

    public Set<? extends EntityField<?, ?>> getFields() {
        return this.fields;
    }

    public PLCondition and(PLCondition other) {
        Objects.requireNonNull(other, "a condition must be provided");
        return new PLCondition(this.jooqCondition.and(other.jooqCondition), this.postFetchCondition.and(other.postFetchCondition), (Set<? extends EntityField<?, ?>>)Sets.union(this.fields, other.fields));
    }

    public PLCondition or(PLCondition other) {
        Objects.requireNonNull(other, "a condition must be provided");
        return new PLCondition(this.jooqCondition.or(other.jooqCondition), this.postFetchCondition.or(other.postFetchCondition), (Set<? extends EntityField<?, ?>>)Sets.union(this.fields, other.fields));
    }

    public static PLCondition not(PLCondition condition) {
        Objects.requireNonNull(condition, "a condition must be provided");
        return new PLCondition(condition.jooqCondition.not(), condition.postFetchCondition.negate(), condition.fields);
    }

    public static PLCondition trueCondition() {
        return new PLCondition((Condition)DSL.trueCondition(), entity -> true, new EntityField[0]);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("jooqCondition", (Object)this.jooqCondition).append("postFetchCondition", this.postFetchCondition).append("fields", this.fields).toString();
    }
}

