/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.CreationDate;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.IgnoredIfSetAlone;
import com.kenshoo.pl.entity.PLContext;
import com.kenshoo.pl.entity.annotation.DefaultValue;
import com.kenshoo.pl.entity.annotation.DontPurge;
import com.kenshoo.pl.entity.annotation.Immutable;
import com.kenshoo.pl.entity.annotation.Required;
import com.kenshoo.pl.entity.annotation.RequiredFieldType;
import com.kenshoo.pl.entity.internal.CreationDateEnricher;
import com.kenshoo.pl.entity.internal.DbCommandsOutputGenerator;
import com.kenshoo.pl.entity.internal.DefaultFieldValueEnricher;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.internal.FalseUpdatesPurger;
import com.kenshoo.pl.entity.spi.PostFetchCommandEnricher;
import java.time.Instant;
import java.util.Optional;
import org.jooq.lambda.tuple.Tuple;

public class ChangeFlowConfigBuilderFactory {
    public static <E extends EntityType<E>> ChangeFlowConfig.Builder<E> newInstance(PLContext plContext, E entityType) {
        ChangeFlowConfig.Builder<E> builder = ChangeFlowConfig.builder(entityType).withOutputGenerator(new DbCommandsOutputGenerator<E>(entityType, plContext)).with(plContext.generateFeatureSet());
        builder.withRetryer(plContext.persistenceLayerRetryer());
        builder.withFalseUpdatesPurger(new FalseUpdatesPurger.Builder().setFieldUnsetter(ChangeEntityCommand::unset).setDeleteIfSetAloneFields(entityType.getFields().filter(EntityTypeReflectionUtil.annotatedWith(entityType, IgnoredIfSetAlone.class))).addFieldsToRetain(entityType.getFields().filter(EntityTypeReflectionUtil.annotatedWith(entityType, DontPurge.class))).retainNonNullableFieldsOfSecondaryTables(entityType).build());
        builder.withRequiredRelationFields(entityType.getFields().filter(EntityTypeReflectionUtil.annotatedWith(entityType, Required.class, required -> required != null && required.value() == RequiredFieldType.RELATION)));
        builder.withRequiredFields(entityType.getFields().filter(EntityTypeReflectionUtil.annotatedWith(entityType, Required.class)));
        builder.withImmutableFields(entityType.getFields().filter(EntityTypeReflectionUtil.annotatedWith(entityType, Immutable.class)));
        Optional<EntityField<E, ?>> creationDateField = entityType.getFields().filter(EntityTypeReflectionUtil.annotatedWith(entityType, CreationDate.class)).findFirst();
        if (creationDateField.isPresent()) {
            if (creationDateField.get().getStringValueConverter().getValueClass() != Instant.class) {
                throw new IllegalArgumentException("Field annotated with @" + CreationDate.class.getSimpleName() + " should be of type " + Instant.class.getName() + ". Field " + entityType.toFieldName(creationDateField.get()) + " has type " + creationDateField.get().getStringValueConverter().getValueClass().getName());
            }
            EntityField<E, ?> entityField2 = creationDateField.get();
            builder.withPostFetchCommandEnricher(new CreationDateEnricher<E>(entityField2));
        }
        entityType.getFields().map(entityField -> Tuple.tuple((Object)entityField, (Object)EntityTypeReflectionUtil.getFieldAnnotation(entityType, entityField, DefaultValue.class))).filter(tuple -> tuple.v2 != null).map(tuple -> ChangeFlowConfigBuilderFactory.defaultFieldValueEnricher((EntityField)tuple.v1, ((DefaultValue)tuple.v2).value())).forEach(builder::withPostFetchCommandEnricher);
        return builder;
    }

    private static <E extends EntityType<E>, T> PostFetchCommandEnricher<E> defaultFieldValueEnricher(EntityField<E, T> field, String value) {
        return new DefaultFieldValueEnricher<E, T>(field, field.getStringValueConverter().convertFrom(value));
    }
}

