/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FeatureSet;
import com.kenshoo.pl.entity.Label;
import com.kenshoo.pl.entity.internal.ChangesFilter;
import com.kenshoo.pl.entity.internal.FalseUpdatesPurger;
import com.kenshoo.pl.entity.internal.MissingEntitiesFilter;
import com.kenshoo.pl.entity.internal.MissingParentEntitiesFilter;
import com.kenshoo.pl.entity.internal.RequiredFieldsChangesFilter;
import com.kenshoo.pl.entity.internal.audit.AuditFieldChangesGenerator;
import com.kenshoo.pl.entity.internal.audit.AuditMandatoryFieldValuesGenerator;
import com.kenshoo.pl.entity.internal.audit.AuditRecordGenerator;
import com.kenshoo.pl.entity.internal.audit.AuditRecordGeneratorImpl;
import com.kenshoo.pl.entity.internal.audit.AuditRequiredFieldsCalculator;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityType;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityTypeResolver;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityTypeResolverImpl;
import com.kenshoo.pl.entity.spi.ChangesValidator;
import com.kenshoo.pl.entity.spi.CurrentStateConsumer;
import com.kenshoo.pl.entity.spi.OutputGenerator;
import com.kenshoo.pl.entity.spi.PersistenceLayerRetryer;
import com.kenshoo.pl.entity.spi.PostFetchCommandEnricher;
import com.kenshoo.pl.entity.spi.helpers.EntityChangeCompositeValidator;
import com.kenshoo.pl.entity.spi.helpers.ImmutableFieldValidatorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class ChangeFlowConfig<E extends EntityType<E>> {
    private static final Label NonExcludebale = new Label(){};
    private final E entityType;
    private final List<PostFetchCommandEnricher<E>> postFetchCommandEnrichers;
    private final List<OutputGenerator<E>> outputGenerators;
    private final List<ChangesValidator<E>> validators;
    private final Set<EntityField<E, ?>> requiredRelationFields;
    private final Set<EntityField<E, ?>> requiredFields;
    private final List<ChangeFlowConfig<? extends EntityType<?>>> childFlows;
    private final List<ChangesFilter<E>> postFetchFilters;
    private final List<ChangesFilter<E>> postSupplyFilters;
    private final PersistenceLayerRetryer retryer;
    private final AuditRequiredFieldsCalculator<E> auditRequiredFieldsCalculator;
    private final AuditRecordGenerator<E> auditRecordGenerator;
    private final FeatureSet features;

    private ChangeFlowConfig(E entityType, List<PostFetchCommandEnricher<E>> postFetchCommandEnrichers, List<ChangesValidator<E>> validators, List<OutputGenerator<E>> outputGenerators, Set<EntityField<E, ?>> requiredRelationFields, Set<EntityField<E, ?>> requiredFields, List<ChangeFlowConfig<? extends EntityType<?>>> childFlows, PersistenceLayerRetryer retryer, AuditRequiredFieldsCalculator<E> auditRequiredFieldsCalculator, AuditRecordGenerator<E> auditRecordGenerator, FeatureSet features) {
        this.entityType = entityType;
        this.postFetchCommandEnrichers = postFetchCommandEnrichers;
        this.outputGenerators = outputGenerators;
        this.validators = validators;
        this.requiredRelationFields = requiredRelationFields;
        this.requiredFields = requiredFields;
        this.childFlows = childFlows;
        this.postFetchFilters = ImmutableList.of(new MissingParentEntitiesFilter(entityType.determineForeignKeys(requiredRelationFields).collect(Collectors.toList())), new MissingEntitiesFilter<E>(entityType));
        this.postSupplyFilters = ImmutableList.of(new RequiredFieldsChangesFilter(requiredFields));
        this.retryer = retryer;
        this.auditRequiredFieldsCalculator = auditRequiredFieldsCalculator;
        this.auditRecordGenerator = auditRecordGenerator;
        this.features = features;
    }

    public E getEntityType() {
        return this.entityType;
    }

    public PersistenceLayerRetryer retryer() {
        return this.retryer;
    }

    public Optional<AuditRecordGenerator<E>> auditRecordGenerator() {
        return Optional.ofNullable(this.auditRecordGenerator);
    }

    public List<PostFetchCommandEnricher<E>> getPostFetchCommandEnrichers() {
        return this.postFetchCommandEnrichers;
    }

    public List<ChangesValidator<E>> getValidators() {
        return this.validators;
    }

    public List<OutputGenerator<E>> getOutputGenerators() {
        return this.outputGenerators;
    }

    public Stream<CurrentStateConsumer<E>> currentStateConsumers() {
        return Seq.concat((Iterable[])new Iterable[]{this.postFetchFilters, this.postSupplyFilters, this.postFetchCommandEnrichers, this.validators, this.outputGenerators}).concat(Optional.ofNullable(this.auditRequiredFieldsCalculator));
    }

    static <E extends EntityType<E>> Builder<E> builder(E entityType) {
        return new Builder<E>(entityType);
    }

    public Set<EntityField<E, ?>> getRequiredRelationFields() {
        return this.requiredRelationFields;
    }

    public Set<EntityField<E, ?>> getRequiredFields() {
        return this.requiredFields;
    }

    public List<ChangeFlowConfig<? extends EntityType<?>>> childFlows() {
        return this.childFlows;
    }

    public List<ChangesFilter<E>> getPostFetchFilters() {
        return this.postFetchFilters;
    }

    public List<ChangesFilter<E>> getPostSupplyFilters() {
        return this.postSupplyFilters;
    }

    public Optional<EntityField<E, Object>> getPrimaryIdentityField() {
        return this.getEntityType().getPrimaryIdentityField();
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    public static class Builder<E extends EntityType<E>> {
        private final E entityType;
        private final List<Labeled<? extends PostFetchCommandEnricher<E>>> postFetchCommandEnrichers = new ArrayList<Labeled<? extends PostFetchCommandEnricher<E>>>();
        private final List<Labeled<ChangesValidator<E>>> validators = new ArrayList<Labeled<ChangesValidator<E>>>();
        private final List<OutputGenerator<E>> outputGenerators = new ArrayList<OutputGenerator<E>>();
        private final Set<EntityField<E, ?>> requiredRelationFields = new HashSet();
        private final Set<EntityField<E, ?>> requiredFields = new HashSet();
        private Optional<PostFetchCommandEnricher<E>> falseUpdatesPurger = Optional.empty();
        private final List<Builder<? extends EntityType<?>>> flowConfigBuilders = new ArrayList();
        private PersistenceLayerRetryer retryer = PersistenceLayerRetryer.JUST_RUN_WITHOUT_CHECKING_DEADLOCKS;
        private AuditedEntityTypeResolver auditedEntityTypeResolver;
        private FeatureSet features = FeatureSet.EMPTY;

        public Builder(E entityType) {
            this.entityType = entityType;
            this.enableAuditing();
        }

        public Builder<E> with(FeatureSet features) {
            this.features = features;
            this.flowConfigBuilders.forEach(builder -> builder.with(features));
            return this;
        }

        public Builder<E> withLabeledPostFetchCommandEnricher(PostFetchCommandEnricher<E> enricher, Label label) {
            this.postFetchCommandEnrichers.add(new Labeled<PostFetchCommandEnricher<E>>(enricher, label));
            return this;
        }

        public Builder<E> withPostFetchCommandEnricher(PostFetchCommandEnricher<E> enricher) {
            this.postFetchCommandEnrichers.add(new Labeled<PostFetchCommandEnricher<E>>(enricher, NonExcludebale));
            return this;
        }

        public Builder<E> withLabeledPostFetchCommandEnrichers(Collection<? extends PostFetchCommandEnricher<E>> enrichers, Label label) {
            enrichers.forEach(e -> this.postFetchCommandEnrichers.add(new Labeled<PostFetchCommandEnricher>((PostFetchCommandEnricher)e, label)));
            return this;
        }

        public Builder<E> withPostFetchCommandEnrichers(Collection<? extends PostFetchCommandEnricher<E>> enrichers) {
            enrichers.forEach(e -> this.postFetchCommandEnrichers.add(new Labeled<PostFetchCommandEnricher>((PostFetchCommandEnricher)e, NonExcludebale)));
            return this;
        }

        void withFalseUpdatesPurger(FalseUpdatesPurger<E> falseUpdatesPurger) {
            this.falseUpdatesPurger = Optional.of(falseUpdatesPurger);
        }

        public Builder<E> withoutFalseUpdatesPurger() {
            this.falseUpdatesPurger = Optional.empty();
            this.flowConfigBuilders.forEach(Builder::withoutFalseUpdatesPurger);
            return this;
        }

        public Builder<E> withValidator(ChangesValidator<E> validator) {
            this.validators.add(new Labeled<ChangesValidator<E>>(validator, NonExcludebale));
            return this;
        }

        public Builder<E> withValidators(Collection<ChangesValidator<E>> validators) {
            validators.forEach(validator -> this.validators.add(new Labeled<ChangesValidator>((ChangesValidator)validator, NonExcludebale)));
            return this;
        }

        public Builder<E> withLabeledValidator(ChangesValidator<E> validator, Label label) {
            this.validators.add(new Labeled<ChangesValidator<E>>(validator, label));
            return this;
        }

        public Builder<E> withLabeledValidators(Collection<ChangesValidator<E>> validators, Label label) {
            validators.forEach(validator -> this.validators.add(new Labeled<ChangesValidator>((ChangesValidator)validator, label)));
            return this;
        }

        public Builder<E> withoutValidators() {
            this.validators.clear();
            this.flowConfigBuilders.forEach(Builder::withoutValidators);
            return this;
        }

        public Builder<E> withoutLabeledElements(Label label) {
            this.withoutLabeledElements((List<Label>)ImmutableList.of((Object)label));
            return this;
        }

        public Builder<E> withoutLabeledElements(List<Label> labels) {
            if (!labels.isEmpty()) {
                this.validators.removeIf(validator -> labels.contains(validator.label()));
                this.postFetchCommandEnrichers.removeIf(enricher -> labels.contains(enricher.label()));
                this.flowConfigBuilders.forEach(builder -> builder.withoutLabeledElements(labels));
            }
            return this;
        }

        public Builder<E> withOutputGenerator(OutputGenerator<E> outputGenerator) {
            this.outputGenerators.add(outputGenerator);
            return this;
        }

        public Builder<E> withOutputGenerators(Collection<? extends OutputGenerator<E>> outputGenerators) {
            this.outputGenerators.addAll(outputGenerators);
            return this;
        }

        public Builder<E> withoutOutputGenerators() {
            this.outputGenerators.clear();
            this.flowConfigBuilders.forEach(Builder::withoutOutputGenerators);
            this.disableAuditing();
            return this;
        }

        public Builder<E> enableAuditing() {
            this.auditedEntityTypeResolver = this.regularAuditedEntityTypeResolver();
            return this;
        }

        public Builder<E> disableAuditing() {
            this.auditedEntityTypeResolver = AuditedEntityTypeResolver.EMPTY;
            return this;
        }

        public Builder<E> withChildFlowBuilder(Builder<? extends EntityType<?>> flowConfigBuilder) {
            this.flowConfigBuilders.add(flowConfigBuilder);
            return this;
        }

        void withRequiredRelationFields(Stream<EntityField<E, ?>> requiredRelationFields) {
            requiredRelationFields.collect(Collectors.toCollection(() -> this.requiredRelationFields));
        }

        void withRequiredFields(Stream<EntityField<E, ?>> requiredFields) {
            requiredFields.collect(Collectors.toCollection(() -> this.requiredFields));
        }

        void withImmutableFields(Stream<EntityField<E, ?>> immutableFields) {
            EntityChangeCompositeValidator compositeValidator = new EntityChangeCompositeValidator();
            immutableFields.forEach(immutableField -> compositeValidator.register(new ImmutableFieldValidatorImpl(immutableField, "persistence.field_is_immutable")));
            this.withValidator(compositeValidator);
        }

        public Builder<E> withRetryer(PersistenceLayerRetryer retryer) {
            this.retryer = retryer;
            return this;
        }

        public ChangeFlowConfig<E> build() {
            ImmutableList.Builder enrichers = ImmutableList.builder();
            this.postFetchCommandEnrichers.forEach(excludableElement -> enrichers.add((Object)((PostFetchCommandEnricher)excludableElement.element())));
            ImmutableList.Builder validatorList = ImmutableList.builder();
            this.validators.forEach(validator -> validatorList.add((Object)((ChangesValidator)validator.element())));
            this.falseUpdatesPurger.ifPresent(arg_0 -> ((ImmutableList.Builder)enrichers).add(arg_0));
            Optional<AuditedEntityType<E>> optionalAuditedEntityType = this.auditedEntityTypeResolver.resolve(this.entityType);
            AuditRequiredFieldsCalculator auditRequiredFieldsCalculator = optionalAuditedEntityType.map(AuditRequiredFieldsCalculator::new).orElse(null);
            AuditRecordGenerator auditRecordGenerator = optionalAuditedEntityType.map(this::createAuditRecordGenerator).orElse(null);
            return new ChangeFlowConfig<E>(this.entityType, enrichers.build(), validatorList.build(), ImmutableList.copyOf(this.outputGenerators), ImmutableSet.copyOf(this.requiredRelationFields), ImmutableSet.copyOf(this.requiredFields), (List<ChangeFlowConfig<EntityType<?>>>)this.flowConfigBuilders.stream().map(Builder::build).collect(Collectors.toList()), this.retryer, auditRequiredFieldsCalculator, auditRecordGenerator, this.features);
        }

        private AuditRecordGenerator<E> createAuditRecordGenerator(AuditedEntityType<E> auditedEntityType) {
            AuditMandatoryFieldValuesGenerator mandatoryFieldValuesGenerator = new AuditMandatoryFieldValuesGenerator(auditedEntityType.getMandatoryFields());
            AuditFieldChangesGenerator<E> fieldChangesGenerator = new AuditFieldChangesGenerator<E>(auditedEntityType.getInternalFields());
            return new AuditRecordGeneratorImpl<E>(mandatoryFieldValuesGenerator, fieldChangesGenerator, auditedEntityType.getName());
        }

        @VisibleForTesting
        AuditedEntityTypeResolver regularAuditedEntityTypeResolver() {
            return AuditedEntityTypeResolverImpl.INSTANCE;
        }

        private static class Labeled<Element> {
            private final Element element;
            private final Label label;

            Labeled(Element element, Label label) {
                this.element = element;
                this.label = label;
            }

            Element element() {
                return this.element;
            }

            Label label() {
                return this.label;
            }
        }
    }
}

