/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Feature;
import com.kenshoo.pl.entity.FeatureSet;
import com.kenshoo.pl.entity.FieldFetchRequest;
import com.kenshoo.pl.entity.Hierarchy;
import com.kenshoo.pl.entity.PersistentLayerStats;
import com.kenshoo.pl.entity.ValidationError;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class ChangeContextImpl
implements ChangeContext {
    private final Multimap<EntityChange, ValidationError> validationErrors = HashMultimap.create();
    private final Map<EntityChange, CurrentEntityState> entities = new IdentityHashMap<EntityChange, CurrentEntityState>();
    private final PersistentLayerStats stats = new PersistentLayerStats();
    private final Set<FieldFetchRequest> fieldsToFetchRequests = Sets.newHashSet();
    private final Hierarchy hierarchy;
    private final FeatureSet features;

    public ChangeContextImpl(Hierarchy hierarchy, FeatureSet features) {
        this.hierarchy = hierarchy;
        this.features = features;
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return this.features.isEnabled(feature);
    }

    @Override
    public CurrentEntityState getEntity(EntityChange entityChange) {
        return this.entities.get(entityChange);
    }

    @Override
    public void addEntity(EntityChange change, CurrentEntityState currentState) {
        this.entities.put(change, currentState);
    }

    @Override
    public void addValidationError(EntityChange<? extends EntityType<?>> entityChange, ValidationError error) {
        this.validationErrors.put(entityChange, (Object)error);
    }

    @Override
    public boolean hasValidationErrors() {
        return !this.validationErrors.isEmpty();
    }

    @Override
    public Seq<ValidationError> getValidationErrors(EntityChange cmd) {
        Seq parentErrors = Seq.seq((Iterable)this.validationErrors.get((Object)cmd));
        if (cmd.getChildren().findAny().isPresent()) {
            Stream<EntityChange<EntityType>> children = cmd.getChildren();
            return parentErrors.concat(children.flatMap(this::getValidationErrors));
        }
        return parentErrors;
    }

    @Override
    public boolean containsError(EntityChange entityChange) {
        return this.getValidationErrors(entityChange).isNotEmpty();
    }

    @Override
    public boolean containsErrorNonRecursive(EntityChange entityChange) {
        return this.validationErrors.containsKey((Object)entityChange);
    }

    @Override
    public PersistentLayerStats getStats() {
        return this.stats;
    }

    void addFetchRequests(Collection<FieldFetchRequest> fetchRequests) {
        this.fieldsToFetchRequests.addAll(fetchRequests);
    }

    @Override
    public Collection<FieldFetchRequest> getFetchRequests() {
        return this.fieldsToFetchRequests;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }
}

