/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.kenshoo.jooq.FieldAndValues;
import com.kenshoo.jooq.TablePopulator;
import com.kenshoo.jooq.TempTableHelper;
import com.kenshoo.jooq.TempTableResource;
import com.kenshoo.jooq.TuplesTempTable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

class TempTableCreator {
    private final TempTableResource tempTableResource;
    private final TuplesTempTable tempTable;

    TempTableCreator(DSLContext dslContext, List<FieldAndValues<?>> fieldsWithValues) {
        this.tempTable = this.createTempTableDefinition(fieldsWithValues);
        this.tempTableResource = TempTableHelper.tempInMemoryTable(dslContext, this.tempTable, new TempTablePopulator(fieldsWithValues));
    }

    public void close() {
        if (this.tempTableResource != null) {
            try {
                this.tempTableResource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SelectOnConditionStep getJoinToTempTableClause(SelectJoinStep joinStep, List<FieldAndValues<?>> fieldsWithValues) {
        Condition joinCondition = this.getJoinToTempTableCondition(fieldsWithValues);
        return joinStep.join((TableLike)this.tempTable).on(joinCondition);
    }

    public String getJoinToTempTableClause(List<FieldAndValues<?>> fieldsWithValues) {
        Condition joinCondition = this.getJoinToTempTableCondition(fieldsWithValues);
        return " JOIN " + this.tempTable.getName() + " ON " + joinCondition.toString().replace("\"", "");
    }

    private Condition getJoinToTempTableCondition(List<FieldAndValues<?>> fieldsWithValues) {
        return (Condition)Seq.seq(fieldsWithValues).zipWithIndex().map(fieldWithIndex -> this.getField((Tuple2<FieldAndValues<?>, Long>)fieldWithIndex).eq(this.getFieldFromTempTable((Tuple2<FieldAndValues<?>, Long>)fieldWithIndex))).reduce(Condition::and).orElse(DSL.trueCondition());
    }

    private Field getField(Tuple2<FieldAndValues<?>, Long> x) {
        return ((FieldAndValues)x.v1).getField();
    }

    private Field getFieldFromTempTable(Tuple2<FieldAndValues<?>, Long> fieldAndIndex) {
        return this.tempTable.field(((Long)fieldAndIndex.v2).intValue());
    }

    private TuplesTempTable createTempTableDefinition(List<FieldAndValues<?>> fieldsWithValues) {
        TuplesTempTable tempTable = new TuplesTempTable();
        for (FieldAndValues<?> fieldsWithValue : fieldsWithValues) {
            tempTable.addField(fieldsWithValue.getField().getName(), fieldsWithValue.getField().getDataType());
        }
        return tempTable;
    }

    public static class TempTablePopulator
    implements TablePopulator {
        private final List<FieldAndValues<?>> fieldsWithValues;

        TempTablePopulator(List<FieldAndValues<?>> fieldsWithValues) {
            this.fieldsWithValues = fieldsWithValues;
        }

        @Override
        public void populate(BatchBindStep batchBindStep) {
            List iterators = this.fieldsWithValues.stream().map(input -> input.getValues().iterator()).collect(Collectors.toList());
            while (((Iterator)iterators.get(0)).hasNext()) {
                batchBindStep.bind((Object[])iterators.stream().map(Iterator::next).toArray(Object[]::new));
            }
        }
    }
}

