/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.kenshoo.jooq.IdsList;
import com.kenshoo.jooq.IdsListImpl;
import com.kenshoo.jooq.IdsTempTable;
import java.util.Collection;
import java.util.Iterator;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectConnectByStep;
import org.jooq.UpdateConditionStep;
import org.jooq.UpdateWhereStep;

public class IntIdsList
extends IdsListImpl<Integer>
implements IdsList<Integer> {
    public IntIdsList(DSLContext dslContext) {
        super(dslContext, IdsTempTable.INT_TABLE);
    }

    public IntIdsList(DSLContext dslContext, Collection<Integer> ids) {
        super(dslContext, IdsTempTable.INT_TABLE, ids);
    }

    public IdsList<Long> asLongIdsList() {
        return new AsLongIdsList();
    }

    private class AsLongIdsList
    implements IdsList<Long> {
        private IdsList<Integer> delegate;

        private AsLongIdsList() {
            this.delegate = IntIdsList.this;
        }

        @Override
        public void add(Long id) {
            throw new UnsupportedOperationException("Adding IDs to int list wrapper is not allowed");
        }

        @Override
        public void addAll(Collection<Long> ids) {
            throw new UnsupportedOperationException("Adding IDs to int list wrapper is not allowed");
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<Long> iterator() {
            return Iterators.transform(this.delegate.iterator(), (Function)new Function<Integer, Long>(){

                public Long apply(Integer input) {
                    return (long)input;
                }
            });
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Closing int list wrapper is not allowed");
        }

        @Override
        public <R extends Record, S extends SelectConnectByStep<R>, FT> S imposeOnQuery(S query, Field<FT> idField) {
            return this.delegate.imposeOnQuery(query, idField);
        }

        @Override
        public <R extends Record, S extends UpdateWhereStep<R>, FT> UpdateConditionStep<R> imposeOnUpdate(S update, Field<FT> idField) {
            return this.delegate.imposeOnUpdate(update, idField);
        }
    }
}

