/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.google.common.base.Preconditions;
import com.kenshoo.jooq.IdsList;
import com.kenshoo.jooq.IdsTempTable;
import com.kenshoo.jooq.TablePopulator;
import com.kenshoo.jooq.TempTableHelper;
import com.kenshoo.jooq.TempTableResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectConnectByStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectWhereStep;
import org.jooq.UpdateConditionStep;
import org.jooq.UpdateWhereStep;

abstract class IdsListImpl<T>
implements IdsList<T> {
    private final DSLContext dslContext;
    private final List<T> ids = new ArrayList<T>();
    private final IdsTempTable<T> idsTempTable;
    private TempTableResource tempTableResource;

    public IdsListImpl(DSLContext dslContext, IdsTempTable<T> idsTempTable) {
        this.dslContext = dslContext;
        this.idsTempTable = idsTempTable;
    }

    public IdsListImpl(DSLContext dslContext, IdsTempTable<T> idsTempTable, Collection<T> ids) {
        this(dslContext, idsTempTable);
        this.ids.addAll(ids);
    }

    @Override
    public void add(T id) {
        this.ids.add(id);
    }

    @Override
    public void addAll(Collection<T> ids) {
        this.ids.addAll(ids);
    }

    @Override
    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.ids.iterator();
    }

    @Override
    public <R extends Record, S extends SelectConnectByStep<R>, FT> S imposeOnQuery(S query, Field<FT> idField) {
        return (S)((SelectConnectByStep)this._imposeOnQuery(query, idField));
    }

    private <FT> Object _imposeOnQuery(Object object, Field<FT> idField) {
        if (this.shouldUseTempTable()) {
            Preconditions.checkArgument((boolean)(object instanceof SelectJoinStep), (Object)("Expected " + SelectJoinStep.class.getName() + " but got " + object.getClass().getName()));
            this.populateTempTable();
            SelectJoinStep query = (SelectJoinStep)object;
            return query.join(this.idsTempTable).on(this.idsTempTable.id.cast(idField.getDataType()).eq(idField));
        }
        Preconditions.checkArgument((boolean)(object instanceof SelectWhereStep), (Object)("Expected " + SelectWhereStep.class.getName() + " but got " + object.getClass().getName()));
        SelectWhereStep query = (SelectWhereStep)object;
        return query.where(idField.in(this.ids));
    }

    @Override
    public <R extends Record, S extends UpdateWhereStep<R>, FT> UpdateConditionStep<R> imposeOnUpdate(S update, Field<FT> idField) {
        return update.where(idField.in(this.ids));
    }

    private void populateTempTable() {
        if (this.tempTableResource != null) {
            return;
        }
        this.tempTableResource = TempTableHelper.tempInMemoryTable(this.dslContext, this.idsTempTable, new TablePopulator(){

            @Override
            public void populate(BatchBindStep batchBindStep) {
                for (Object id : IdsListImpl.this.ids) {
                    batchBindStep.bind(new Object[]{id});
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.tempTableResource != null) {
            this.tempTableResource.close();
        }
    }

    private boolean shouldUseTempTable() {
        return this.ids.size() > 10;
    }

    public List<T> getIds() {
        return this.ids;
    }
}

