/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T2CDriverExtension() {
    }

    @Override
    Connection getConnection(String string, Properties properties) throws SQLException {
        T2CConnection t2CConnection = null;
        t2CConnection = properties.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(string, properties, (Object)this) : new T2CConnection(string, properties, this);
        return t2CConnection;
    }

    @Override
    OracleStatement allocateStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        return new T2CStatement((T2CConnection)physicalConnection, 1, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T2CPreparedStatement((T2CConnection)physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    @Override
    OracleCallableStatement allocateCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T2CCallableStatement((T2CConnection)physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T2CInputStream(oracleStatement, n2, accessor);
    }
}

