/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.extra;

import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HashMapSerializer
extends CycleFlagSerializer
implements FseSerializer {
    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        HashMap map = (HashMap)o;
        byteArray.writePositive(map.size());
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            fseContext.serialize(entry.getKey(), byteArray, depth);
            fseContext.serialize(entry.getValue(), byteArray, depth);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        fseContext.collectObject(map);
        int size = byteArray.readPositive();
        for (int i = 0; i < size; ++i) {
            int result = byteArray.readVarInt();
            Object key = result > 0 ? fseContext.getClassRegistry(result).getSerializer().readBytes(byteArray, fseContext) : fseContext.getObjectByIndex(0 - result);
            result = byteArray.readVarInt();
            Object value = result == 0 ? null : (result > 0 ? fseContext.getClassRegistry(result).getSerializer().readBytes(byteArray, fseContext) : fseContext.getObjectByIndex(0 - result));
            map.put(key, value);
        }
        return map;
    }
}

