/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.extra;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;
import java.util.HashMap;
import java.util.Map;

public class ClassSerializer
extends CycleFlagSerializer
implements FseSerializer {
    private Map<String, Class> nameToClass = new HashMap<String, Class>();

    public ClassSerializer() {
        this.nameToClass.put("void", Void.TYPE);
    }

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        byteArray.writeString(((Class)o).getName());
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        String className = byteArray.readString();
        Class<?> ckass = this.nameToClass.get(className);
        if (ckass != null) {
            return ckass;
        }
        try {
            ckass = Class.forName(className);
            this.nameToClass.put(className, ckass);
            return ckass;
        }
        catch (ClassNotFoundException e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }
}

