/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.array;

import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;

public class StringArraySerializer
extends CycleFlagSerializer
implements FseSerializer {
    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        this.writeElement((String[])o, byteArray);
    }

    private void writeElement(String[] o, InternalByteArray byteArray) {
        String[] array = o;
        byteArray.writePositive(array.length);
        for (String each : array) {
            byteArray.writeString(each);
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int len = byteArray.readPositive();
        return this.readElement(byteArray, len);
    }

    private Object readElement(InternalByteArray byteArray, int len) {
        String[] array = new String[len];
        for (int i = 0; i < len; ++i) {
            array[i] = byteArray.readString();
        }
        return array;
    }
}

