/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse;

import java.util.IdentityHashMap;

public class ObjectCollector {
    protected IdentityHashMap<Object, Integer> store;
    protected Object[] data;
    protected int sequence = 0;

    public ObjectCollector() {
        this(64);
    }

    public ObjectCollector(int len) {
        this.data = new Object[len];
        this.store = new IdentityHashMap(len);
    }

    public int collect(Object src) {
        Integer exist = this.store.get(src);
        if (exist != null) {
            return exist;
        }
        if (this.sequence == this.data.length) {
            Object[] tmp = new Object[this.data.length << 1];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
        this.data[this.sequence] = src;
        ++this.sequence;
        this.store.put(src, this.sequence);
        return -1;
    }

    public void clear() {
        for (int i = 0; i < this.sequence; ++i) {
            this.data[i] = null;
        }
        this.store.clear();
        this.sequence = 0;
    }

    public Object getObject(int i) {
        return this.data[i - 1];
    }
}

