/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.io.codec.Base64;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.UrlUtil;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.resolver.resource.SimpleImageCache;
import com.itextpdf.styledxmlparser.resolver.resource.UriResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolver {
    public static final String BASE64IDENTIFIER = "base64";
    public static final String DATA_SCHEMA_PREFIX = "data:";
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolver.class);
    private UriResolver uriResolver;
    private SimpleImageCache imageCache;

    public ResourceResolver(String baseUri) {
        if (baseUri == null) {
            baseUri = "";
        }
        this.uriResolver = new UriResolver(baseUri);
        this.imageCache = new SimpleImageCache();
    }

    @Deprecated
    public PdfImageXObject retrieveImage(String src) {
        PdfXObject image = this.retrieveImageExtended(src);
        if (image instanceof PdfImageXObject) {
            return (PdfImageXObject)image;
        }
        return null;
    }

    public PdfXObject retrieveImageExtended(String src) {
        if (src != null) {
            PdfXObject imageXObject;
            if (this.isContains64Mark(src) && (imageXObject = this.tryResolveBase64ImageSource(src)) != null) {
                return imageXObject;
            }
            imageXObject = this.tryResolveUrlImageSource(src);
            if (imageXObject != null) {
                return imageXObject;
            }
        }
        logger.error(MessageFormatUtil.format((String)"Unable to retrieve image with given base URI ({0}) and image source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}));
        return null;
    }

    public InputStream retrieveStyleSheet(String uri) throws IOException {
        return this.uriResolver.resolveAgainstBaseUri(uri).openStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public byte[] retrieveStream(String src) {
        try (InputStream stream = this.retrieveResourceAsInputStream(src);){
            if (stream != null) {
                byte[] byArray2 = StreamUtil.inputStreamToArray((InputStream)stream);
                return byArray2;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] retrieveBytesFromResource(String src) {
        try (InputStream stream = this.retrieveResourceAsInputStream(src);){
            byte[] byArray = stream == null ? null : StreamUtil.inputStreamToArray((InputStream)stream);
            return byArray;
        }
        catch (IOException ioe) {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)ioe);
            return null;
        }
    }

    public InputStream retrieveResourceAsInputStream(String src) {
        if (this.isContains64Mark(src)) {
            try {
                String fixedSrc = src.replaceAll("\\s", "");
                fixedSrc = fixedSrc.substring(fixedSrc.indexOf(BASE64IDENTIFIER) + 7);
                return new ByteArrayInputStream(Base64.decode((String)fixedSrc));
            }
            catch (Exception fixedSrc) {
                // empty catch block
            }
        }
        try {
            return this.uriResolver.resolveAgainstBaseUri(src).openStream();
        }
        catch (Exception e) {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)e);
            return null;
        }
    }

    private boolean isContains64Mark(String src) {
        return src.contains(BASE64IDENTIFIER);
    }

    public URL resolveAgainstBaseUri(String uri) throws MalformedURLException {
        return this.uriResolver.resolveAgainstBaseUri(uri);
    }

    public void resetCache() {
        this.imageCache.reset();
    }

    public boolean isImageTypeSupportedByImageDataFactory(String src) {
        try {
            URL url = this.uriResolver.resolveAgainstBaseUri(src);
            url = UrlUtil.getFinalURL((URL)url);
            return ImageDataFactory.isSupportedType((URL)url);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected PdfXObject tryResolveBase64ImageSource(String src) {
        try {
            String fixedSrc = src.replaceAll("\\s", "");
            fixedSrc = fixedSrc.substring(fixedSrc.indexOf(BASE64IDENTIFIER) + 7);
            PdfXObject imageXObject = this.imageCache.getImage(fixedSrc);
            if (imageXObject == null) {
                imageXObject = new PdfImageXObject(ImageDataFactory.create((byte[])Base64.decode((String)fixedSrc)));
                this.imageCache.putImage(fixedSrc, imageXObject);
            }
            return imageXObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PdfXObject tryResolveUrlImageSource(String uri) {
        try {
            URL url = this.uriResolver.resolveAgainstBaseUri(uri);
            url = UrlUtil.getFinalURL((URL)url);
            String imageResolvedSrc = url.toExternalForm();
            PdfXObject imageXObject = this.imageCache.getImage(imageResolvedSrc);
            if (imageXObject == null) {
                imageXObject = this.createImageByUrl(url);
                this.imageCache.putImage(imageResolvedSrc, imageXObject);
            }
            return imageXObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PdfXObject createImageByUrl(URL url) throws Exception {
        return new PdfImageXObject(ImageDataFactory.create((URL)url));
    }

    public boolean isDataSrc(String src) {
        return src.startsWith(DATA_SCHEMA_PREFIX) && src.contains(",");
    }
}

