/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.BodyHtmlStylesContainer;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlBodyStylesApplierHandler;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreak;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreakType;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProcessor;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProperties;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElement;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.RootLayoutArea;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HtmlDocumentRenderer
extends DocumentRenderer {
    private static final boolean TRIM_LAST_BLANK_PAGE = true;
    private PageContextProcessor firstPageProc;
    private PageContextProcessor leftPageProc;
    private PageContextProcessor rightPageProc;
    private boolean evenPagesAreLeft = true;
    private PageMarginBoxesDrawingHandler marginBoxesHandler;
    private HtmlBodyStylesApplierHandler htmlBodyHandler;
    private Map<Integer, HtmlBodyStylesApplierHandler.PageStylesProperties> pageStylesPropertiesMap = new HashMap<Integer, HtmlBodyStylesApplierHandler.PageStylesProperties>();
    private IRenderer waitingElement;
    private boolean shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = true;
    private boolean anythingAddedToCurrentArea = false;
    private int estimatedNumberOfPages;

    public HtmlDocumentRenderer(Document document, boolean immediateFlush) {
        super(document, immediateFlush);
        this.htmlBodyHandler = new HtmlBodyStylesApplierHandler(this, this.pageStylesPropertiesMap);
        document.getPdfDocument().addEventHandler("EndPdfPage", (IEventHandler)this.htmlBodyHandler);
    }

    public void processPageRules(INode rootNode, ICssResolver cssResolver, ProcessorContext context) {
        PageContextProperties firstPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "first", "right");
        PageContextProperties leftPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "left");
        PageContextProperties rightPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "right");
        PageSize defaultPageSize = this.document.getPdfDocument().getDefaultPageSize();
        float[] defaultPageMargins = new float[]{this.document.getTopMargin(), this.document.getRightMargin(), this.document.getBottomMargin(), this.document.getRightMargin()};
        this.firstPageProc = new PageContextProcessor(firstPageProps, context, defaultPageSize, defaultPageMargins);
        this.leftPageProc = new PageContextProcessor(leftPageProps, context, defaultPageSize, defaultPageMargins);
        this.rightPageProc = new PageContextProcessor(rightPageProps, context, defaultPageSize, defaultPageMargins);
        this.marginBoxesHandler = new PageMarginBoxesDrawingHandler().setHtmlDocumentRenderer(this);
        this.document.getPdfDocument().addEventHandler("EndPdfPage", (IEventHandler)this.marginBoxesHandler);
    }

    public void addChild(IRenderer renderer) {
        if (this.waitingElement != null) {
            if (Boolean.TRUE.equals(renderer.getProperty(0x100001))) {
                this.waitingElement.setProperty(81, (Object)true);
            }
            IRenderer element = this.waitingElement;
            this.waitingElement = null;
            super.addChild(element);
            if (!HtmlDocumentRenderer.isRunningElementsOnly(element)) {
                this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = false;
            }
        }
        this.waitingElement = renderer;
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)renderer.getProperty(99);
        Integer position = (Integer)renderer.getProperty(52);
        if (position != null && position == 3 || floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE)) {
            this.waitingElement = null;
            super.addChild(renderer);
        }
    }

    public void close() {
        this.processWaitingElement();
        super.close();
        this.trimLastPageIfNecessary();
        this.document.getPdfDocument().removeEventHandler("EndPdfPage", (IEventHandler)this.marginBoxesHandler);
        this.document.getPdfDocument().removeEventHandler("EndPdfPage", (IEventHandler)this.htmlBodyHandler);
        for (int i = 1; i <= this.document.getPdfDocument().getNumberOfPages(); ++i) {
            PdfPage page = this.document.getPdfDocument().getPage(i);
            if (page.isFlushed()) continue;
            this.marginBoxesHandler.processPage(this.document.getPdfDocument(), i);
            this.htmlBodyHandler.processPage(page, i);
        }
    }

    void removeEventHandlers() {
        this.document.getPdfDocument().removeEventHandler("EndPdfPage", (IEventHandler)this.htmlBodyHandler);
        this.document.getPdfDocument().removeEventHandler("EndPdfPage", (IEventHandler)this.marginBoxesHandler);
    }

    public IRenderer getNextRenderer() {
        this.processWaitingElement();
        HtmlDocumentRenderer relayoutRenderer = new HtmlDocumentRenderer(this.document, this.immediateFlush);
        PageSize defaultPageSize = this.document.getPdfDocument().getDefaultPageSize();
        float[] defaultPageMargins = new float[]{this.document.getTopMargin(), this.document.getRightMargin(), this.document.getBottomMargin(), this.document.getRightMargin()};
        relayoutRenderer.firstPageProc = this.firstPageProc.reset(defaultPageSize, defaultPageMargins);
        relayoutRenderer.leftPageProc = this.leftPageProc.reset(defaultPageSize, defaultPageMargins);
        relayoutRenderer.rightPageProc = this.rightPageProc.reset(defaultPageSize, defaultPageMargins);
        relayoutRenderer.estimatedNumberOfPages = this.currentArea == null ? this.estimatedNumberOfPages : this.currentArea.getPageNumber() - this.simulateTrimLastPage();
        relayoutRenderer.marginBoxesHandler = this.marginBoxesHandler.setHtmlDocumentRenderer(relayoutRenderer);
        relayoutRenderer.targetCounterHandler = new TargetCounterHandler(this.targetCounterHandler);
        return relayoutRenderer;
    }

    public void flush() {
        this.processWaitingElement();
        super.flush();
    }

    public void processWaitingElement() {
        if (this.waitingElement != null) {
            IRenderer r = this.waitingElement;
            this.waitingElement = null;
            super.addChild(r);
        }
    }

    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        AreaBreak areaBreak;
        AreaBreak areaBreak2 = areaBreak = overflowResult != null ? overflowResult.getAreaBreak() : null;
        if (areaBreak instanceof HtmlPageBreak) {
            HtmlPageBreakType htmlPageBreakType = ((HtmlPageBreak)areaBreak).getBreakType();
            if (this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement && this.currentArea != null && overflowResult.getStatus() == 3 && this.currentArea.isEmptyArea() && this.currentArea.getPageNumber() == 1) {
                this.document.getPdfDocument().removePage(1);
                overflowResult = null;
                this.currentArea = null;
                this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = false;
                if (HtmlPageBreakType.LEFT.equals((Object)htmlPageBreakType) && !this.isPageLeft(1) || HtmlPageBreakType.RIGHT.equals((Object)htmlPageBreakType) && !this.isPageRight(1)) {
                    this.evenPagesAreLeft = !this.evenPagesAreLeft;
                }
            }
            boolean bl = this.anythingAddedToCurrentArea = this.anythingAddedToCurrentArea || overflowResult != null && overflowResult.getStatus() == 2;
            if (HtmlPageBreakType.ALWAYS.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null) {
                    nextArea = super.updateCurrentArea(overflowResult);
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
            if (HtmlPageBreakType.LEFT.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null || !this.isPageLeft(this.currentArea.getPageNumber())) {
                    do {
                        nextArea = super.updateCurrentArea(overflowResult);
                    } while (!this.isPageLeft(this.currentArea.getPageNumber()));
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
            if (HtmlPageBreakType.RIGHT.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null || !this.isPageRight(this.currentArea.getPageNumber())) {
                    do {
                        nextArea = super.updateCurrentArea(overflowResult);
                    } while (!this.isPageRight(this.currentArea.getPageNumber()));
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
        }
        this.anythingAddedToCurrentArea = false;
        return super.updateCurrentArea(overflowResult);
    }

    protected void shrinkCurrentAreaAndProcessRenderer(IRenderer renderer, List<IRenderer> resultRenderers, LayoutResult result) {
        if (renderer != null) {
            this.anythingAddedToCurrentArea = true;
        }
        super.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
    }

    protected void flushSingleRenderer(IRenderer resultRenderer) {
        if (!this.isElementOnNonStaticLayout(resultRenderer)) {
            LayoutArea area = resultRenderer.getOccupiedArea();
            this.updateLowestAndHighestPoints(area.getBBox(), area.getPageNumber());
        }
        super.flushSingleRenderer(resultRenderer);
    }

    protected PageSize addNewPage(PageSize customPageSize) {
        int pageNumber = this.document.getPdfDocument().getNumberOfPages() + 1;
        PageContextProcessor nextProcessor = this.getPageProcessor(pageNumber);
        PdfPage addedPage = customPageSize != null ? this.document.getPdfDocument().addNewPage(customPageSize) : this.document.getPdfDocument().addNewPage(nextProcessor.getPageSize());
        nextProcessor.processNewPage(addedPage);
        float[] margins = nextProcessor.computeLayoutMargins();
        BodyHtmlStylesContainer[] styles = new BodyHtmlStylesContainer[]{(BodyHtmlStylesContainer)this.document.getProperty(0x10000B), (BodyHtmlStylesContainer)this.document.getProperty(0x10000A)};
        this.pageStylesPropertiesMap.put(pageNumber, new HtmlBodyStylesApplierHandler.PageStylesProperties(styles));
        this.updateDefaultMargins(styles, margins);
        this.setProperty(46, Float.valueOf(margins[0]));
        this.setProperty(45, Float.valueOf(margins[1]));
        this.setProperty(43, Float.valueOf(margins[2]));
        this.setProperty(44, Float.valueOf(margins[3]));
        return new PageSize(addedPage.getTrimBox());
    }

    boolean shouldAttemptTrimLastPage() {
        return this.document.getPdfDocument().getNumberOfPages() > 1;
    }

    void trimLastPageIfNecessary() {
        PdfDocument pdfDocument;
        PdfPage lastPage;
        if (this.shouldAttemptTrimLastPage() && (lastPage = (pdfDocument = this.document.getPdfDocument()).getLastPage()).getContentStreamCount() == 1 && lastPage.getContentStream(0).getOutputStream().getCurrentPos() <= 0L) {
            pdfDocument.removePage(pdfDocument.getNumberOfPages());
        }
    }

    int simulateTrimLastPage() {
        if (this.shouldAttemptTrimLastPage()) {
            int lastPageNumber = this.document.getPdfDocument().getNumberOfPages();
            boolean willAnyContentBeDrawnOnLastPage = false;
            for (IRenderer renderer : this.childRenderers) {
                if (renderer.getOccupiedArea().getPageNumber() != lastPageNumber) continue;
                willAnyContentBeDrawnOnLastPage = true;
            }
            for (IRenderer renderer : this.positionedRenderers) {
                if (renderer.getOccupiedArea().getPageNumber() != lastPageNumber) continue;
                willAnyContentBeDrawnOnLastPage = true;
            }
            return willAnyContentBeDrawnOnLastPage ? 0 : 1;
        }
        return 0;
    }

    PageContextProcessor getPageProcessor(int pageNum) {
        if (pageNum == 1 && this.evenPagesAreLeft) {
            return this.firstPageProc;
        }
        if (this.isPageLeft(pageNum)) {
            return this.leftPageProc;
        }
        return this.rightPageProc;
    }

    int getEstimatedNumberOfPages() {
        return this.estimatedNumberOfPages;
    }

    private void updateDefaultMargins(BodyHtmlStylesContainer[] styles, float[] defaultMargins) {
        for (int i = 0; i < 2; ++i) {
            if (styles[i] == null) continue;
            for (int j = 0; j < 4; ++j) {
                int n = j;
                defaultMargins[n] = defaultMargins[n] + styles[i].getTotalWidth()[j];
            }
        }
    }

    private boolean isElementOnNonStaticLayout(IRenderer resultRenderer) {
        boolean nonStaticLayout = false;
        if (resultRenderer.hasProperty(52)) {
            int positionProperty = (Integer)resultRenderer.getProperty(52);
            boolean bl = nonStaticLayout = positionProperty == 3 || positionProperty == 4;
        }
        if (!nonStaticLayout && resultRenderer.hasProperty(99)) {
            FloatPropertyValue floatProperty = (FloatPropertyValue)resultRenderer.getProperty(99);
            nonStaticLayout = floatProperty == FloatPropertyValue.LEFT || floatProperty == FloatPropertyValue.RIGHT;
        }
        return nonStaticLayout;
    }

    private void updateLowestAndHighestPoints(Rectangle rectangle, int page) {
        if (!this.pageStylesPropertiesMap.containsKey(page)) {
            return;
        }
        HtmlBodyStylesApplierHandler.LowestAndHighest currentPagePoints = this.pageStylesPropertiesMap.get((Object)Integer.valueOf((int)page)).lowestAndHighest;
        if (currentPagePoints == null) {
            this.pageStylesPropertiesMap.get((Object)Integer.valueOf((int)page)).lowestAndHighest = new HtmlBodyStylesApplierHandler.LowestAndHighest(rectangle.getY(), rectangle.getY() + rectangle.getHeight());
        } else {
            float newLowestPoint = rectangle.getY();
            float newHighestPoint = rectangle.getY() + rectangle.getHeight();
            currentPagePoints.lowest = Math.min(newLowestPoint, currentPagePoints.lowest);
            currentPagePoints.highest = Math.max(newHighestPoint, currentPagePoints.highest);
        }
    }

    private static boolean isRunningElementsOnly(IRenderer waitingElement) {
        boolean res = waitingElement instanceof ParagraphRenderer && !waitingElement.getChildRenderers().isEmpty();
        if (res) {
            List childRenderers = waitingElement.getChildRenderers();
            int i = 0;
            while (res && i < childRenderers.size()) {
                res = childRenderers.get(i++) instanceof RunningElement.RunningElementRenderer;
            }
        }
        return res;
    }

    private boolean isPageLeft(int pageNum) {
        boolean pageIsEven = pageNum % 2 == 0;
        return this.evenPagesAreLeft == pageIsEven;
    }

    private boolean isPageRight(int pageNum) {
        return !this.isPageLeft(pageNum);
    }

    private static class PageMarginBoxesDrawingHandler
    implements IEventHandler {
        private HtmlDocumentRenderer htmlDocumentRenderer;

        private PageMarginBoxesDrawingHandler() {
        }

        PageMarginBoxesDrawingHandler setHtmlDocumentRenderer(HtmlDocumentRenderer htmlDocumentRenderer) {
            this.htmlDocumentRenderer = htmlDocumentRenderer;
            return this;
        }

        public void handleEvent(Event event) {
            if (event instanceof PdfDocumentEvent) {
                PdfPage page = ((PdfDocumentEvent)event).getPage();
                PdfDocument pdfDoc = ((PdfDocumentEvent)event).getDocument();
                int pageNumber = pdfDoc.getPageNumber(page);
                this.processPage(pdfDoc, pageNumber);
            }
        }

        void processPage(PdfDocument pdfDoc, int pageNumber) {
            PageContextProcessor pageProcessor = this.htmlDocumentRenderer.getPageProcessor(pageNumber);
            pageProcessor.processPageEnd(pageNumber, pdfDoc, this.htmlDocumentRenderer);
        }
    }
}

