/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class ResponseLoggingInterceptor
implements HttpResponseInterceptor {
    private final ScriptContext context;
    private final AtomicInteger counter;

    public ResponseLoggingInterceptor(AtomicInteger counter, ScriptContext context) {
        this.counter = counter;
        this.context = context;
    }

    public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
        if (!this.context.logger.isDebugEnabled()) {
            return;
        }
        int id = this.counter.get();
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" < ").append(response.getStatusLine().getStatusCode()).append('\n');
        LoggingUtils.logHeaders(sb, id, '<', response);
        HttpEntity entity = response.getEntity();
        if (LoggingUtils.isPrintable(entity)) {
            LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
            String buffer = FileUtils.toString((InputStream)wrapper.getContent());
            sb.append(buffer).append('\n');
            response.setEntity((HttpEntity)wrapper);
        }
        this.context.logger.debug(sb.toString());
    }
}

