/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.metrics.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

public class Utils {
    private static Random random = new Random();

    public static boolean getRandomBoolean() {
        return random.nextBoolean();
    }

    public static int getRandomIntBetween(int max, int min) {
        assert (max > min);
        return Utils.getRandomIntInInterval(max - min) + min;
    }

    public static int getRandomIntInInterval(int duration) {
        return random.nextInt(duration);
    }

    public static String getUniqueId() {
        return String.valueOf(DateTime.now().getMillis() + (long)Utils.getRandomIntBetween(10000, 54));
    }

    public static Minutes getMinutesBetween(DateTime start, DateTime end) {
        return Minutes.minutesBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    public static List<Interval> getSessionMinutes(DateTime start, DateTime end, int max, int min, int count) {
        ArrayList sequence = Lists.newArrayList();
        DateTime startDateTime = start.plus((ReadablePeriod)Minutes.minutes((int)Utils.getRandomIntBetween(max, min)));
        for (int i = 0; i < count; ++i) {
            Minutes randomPeriod = Minutes.minutes((int)Utils.getRandomIntBetween(max, min));
            if (i > 0) {
                startDateTime = startDateTime.plus((ReadablePeriod)Days.days((int)Utils.getRandomIntBetween(2, 1)));
            }
            DateTime endDateTime = startDateTime.plus((long)min).plus((ReadablePeriod)randomPeriod);
            sequence.add(new Interval((ReadableInstant)startDateTime, (ReadableInstant)endDateTime));
        }
        return sequence;
    }

    public static DateTime getRandomTime(DateTime startTime, Hours hours) {
        Random random = new Random();
        DateTime startDateTime = startTime;
        Minutes minimumPeriod = Minutes.TWO;
        int minimumPeriodInSeconds = minimumPeriod.toStandardSeconds().getSeconds();
        int maximumPeriodInSeconds = hours.toStandardSeconds().getSeconds();
        Seconds randomPeriod = Seconds.seconds((int)random.nextInt(maximumPeriodInSeconds - minimumPeriodInSeconds));
        DateTime endDateTime = startDateTime.plus((ReadablePeriod)minimumPeriod).plus((ReadablePeriod)randomPeriod);
        return endDateTime;
    }
}

