/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.metrics.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellifylearning.metrics.models.Activity;
import com.intellifylearning.metrics.models.Metric;
import com.intellifylearning.metrics.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VideoActivity
extends Activity {
    private Metric playVideo = Metric.define("video-1111", "play-video", null);
    private Metric pauseVideo = Metric.define("video-2222", "pause-video", null);
    private Metric commentVideo = Metric.define("video-3333", "comment-video", null);
    private Metric finishVideo = Metric.define("video-4444", "finish-video", null);
    private int viewTime = 15;

    public VideoActivity() {
        this.setType(this.TYPE_VIDEO);
        this.metrics.add(this.playVideo);
        this.metrics.add(this.pauseVideo);
        this.metrics.add(this.commentVideo);
        this.metrics.add(this.finishVideo);
    }

    @Override
    public List<Metric> getLogicalMetricSequence() {
        ArrayList metricList = Lists.newArrayList();
        metricList.add(this.getStartActivityMetric());
        Object metric = null;
        boolean videoPlayed = false;
        for (int i = 0; i < Utils.getRandomIntBetween(2, 1); ++i) {
            metricList.add(this.getPlayVideoMetric());
            videoPlayed = true;
        }
        if (videoPlayed) {
            int i;
            boolean videoPaused = false;
            for (i = 0; i < Utils.getRandomIntBetween(4, 1); ++i) {
                metricList.add(this.getPauseVideoMetric());
                videoPaused = true;
            }
            for (i = 0; i < Utils.getRandomIntBetween(2, 1); ++i) {
                metricList.add(this.getCommentVideoMetric());
            }
            boolean finishVideo = Utils.getRandomBoolean();
            if (finishVideo) {
                metricList.add(this.addVideoViewTimeData(this.getFinishVideoMetric()));
            }
        }
        metricList.add(VideoActivity.getCompleteActivityMetric());
        return metricList;
    }

    private Metric addVideoViewTimeData(Metric metric) {
        int viewTime = this.getViewTime();
        HashMap metricData = Maps.newHashMap();
        metricData.put("actual-view-time", String.valueOf(Utils.getRandomIntBetween(viewTime, 1)));
        metricData.put("view-time", String.valueOf(viewTime));
        Metric finishVideoMetric = new Metric();
        finishVideoMetric.setId(metric.getId());
        finishVideoMetric.setName(metric.getName());
        finishVideoMetric.setMetricData(metricData);
        System.out.println("Added video finish metadata: " + metricData);
        return finishVideoMetric;
    }

    public Metric getPlayVideoMetric() {
        return this.playVideo;
    }

    public Metric getPauseVideoMetric() {
        return this.pauseVideo;
    }

    public Metric getCommentVideoMetric() {
        return this.commentVideo;
    }

    public Metric getFinishVideoMetric() {
        return this.finishVideo;
    }

    public int getViewTime() {
        return this.viewTime;
    }

    public void setViewTime(int viewTime) {
        this.viewTime = viewTime;
    }
}

