/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.metrics.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellifylearning.metrics.models.Activity;
import com.intellifylearning.metrics.models.Metric;
import com.intellifylearning.metrics.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReadingActivity
extends Activity {
    public ReadingActivity() {
        this.setType(this.TYPE_READING);
        HashMap emptyMap = Maps.newHashMap();
        this.metrics.add(Metric.define("read-1111", "add-hilight", emptyMap));
        this.metrics.add(Metric.define("read-2222", "add-note", emptyMap));
        this.metrics.add(Metric.define("read-3333", "read-page", emptyMap));
        this.metrics.add(Metric.define("read-4444", "add-bookmark", emptyMap));
    }

    @Override
    public List<Metric> getLogicalMetricSequence() {
        ArrayList metricList = Lists.newArrayList();
        metricList.add(this.getStartActivityMetric());
        for (int i = 0; i < Utils.getRandomIntBetween(10, 2); ++i) {
            Metric metric = this.getRandomMetric();
            if (metric.getId().equals("read-3333")) {
                metric = this.addPageReadMetricData(metric);
            }
            metricList.add(metric);
        }
        metricList.add(ReadingActivity.getCompleteActivityMetric());
        return metricList;
    }

    private Metric addPageReadMetricData(Metric metric) {
        int numPages = 5;
        int randomPageNumber = Utils.getRandomIntBetween(5, 1);
        HashMap metricData = Maps.newHashMap();
        metricData.put("page-number", String.valueOf(randomPageNumber));
        metricData.put("number-of-pages", String.valueOf(numPages));
        Metric pageReadMetric = new Metric();
        pageReadMetric.setId(metric.getId());
        pageReadMetric.setName(metric.getName());
        pageReadMetric.setMetricData(metricData);
        return pageReadMetric;
    }
}

